/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.lzma;

import de.carne.filescanner.engine.FileScannerResultContextValueSpecs;
import de.carne.filescanner.engine.format.ByteSpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.DWordSpec;
import de.carne.filescanner.engine.format.EncodedInputSpecConfig;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.QWordSpec;
import de.carne.filescanner.engine.input.InputDecoderTable;
import de.carne.filescanner.engine.util.LzmaInputDecoder;
import de.carne.nio.compression.lzma.LzmaDecoderProperties;
import de.carne.nio.file.FileUtil;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class LzmaFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> lzmaFormatSpec = this.resolveLazy("LZMA_ARCHIVE", CompositeSpec.class);
    private Lazy<CompositeSpec> lzmaHeaderSpec = this.resolveLazy("LZMA_HEADER", CompositeSpec.class);
    private Lazy<ByteSpec> lzmaProperties = this.resolveLazy("PROPERTIES", ByteSpec.class);
    private Lazy<DWordSpec> dictionarySize = this.resolveLazy("DICTIONARY_SIZE", DWordSpec.class);
    private Lazy<QWordSpec> uncompressedSize = this.resolveLazy("UNCOMPRESSED_SIZE", QWordSpec.class);
    private static final byte LZMA_PROPERTIES_3_0_2 = 93;
    private static final int MIN_DICTIONARY_SIZE = 65536;
    private static final int MAX_DICTIONARY_SIZE = 0x4000000;
    private static final long UNKNOWN_UNCOMPRESSED_SIZE = -1L;
    private static final long MIN_UNCOMPRESSED_SIZE = 1L;
    private static final long MAX_UNCOMPRESSED_SIZE = 0x4000000000L;
    private static final Map<String, String> MANGLED_EXTENSION_MAP = new HashMap<String, String>();

    LzmaFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("Lzma.formatspec"));
    }

    @Override
    protected void afterLoad() {
        ((ByteSpec)this.lzmaProperties.get()).validate(LzmaFormatSpecDefinition::validateLzmaProperties);
        ((DWordSpec)this.dictionarySize.get()).validate(LzmaFormatSpecDefinition::validateDictionarySize);
        ((QWordSpec)this.uncompressedSize.get()).validate(LzmaFormatSpecDefinition::validateUncompressedSize);
    }

    private static boolean validateLzmaProperties(Byte value) {
        byte propertiesValue = value;
        return propertiesValue == 93;
    }

    private static boolean validateDictionarySize(Integer value) {
        int dictionarySizeValue = value;
        int lowestBit = Integer.lowestOneBit(dictionarySizeValue);
        int highestBit = Integer.highestOneBit(dictionarySizeValue);
        return highestBit != 0 && (lowestBit == highestBit || lowestBit << 1 == highestBit) && 65536 <= dictionarySizeValue && dictionarySizeValue <= 0x4000000;
    }

    private static boolean validateUncompressedSize(Long value) {
        long uncompressedSizeValue = value;
        return uncompressedSizeValue == -1L || 1L <= uncompressedSizeValue && uncompressedSizeValue <= 0x4000000000L;
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.lzmaFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.lzmaHeaderSpec.get();
    }

    public EncodedInputSpecConfig lzmaEncodedInputConfig() {
        return new EncodedInputSpecConfig("Compressed data").decodedInputName(this::decodedInputName).inputDecoderTable(this::inputDecoderTable);
    }

    private String decodedInputName() {
        String[] splitInputName = FileUtil.splitPath((String)((String)FileScannerResultContextValueSpecs.INPUT_NAME.get()));
        return splitInputName[1] + MANGLED_EXTENSION_MAP.getOrDefault(splitInputName[2], "");
    }

    private InputDecoderTable inputDecoderTable() {
        LzmaDecoderProperties properties = LzmaInputDecoder.defaultProperties();
        properties.setLcLpBpProperty(((Byte)((ByteSpec)this.lzmaProperties.get()).get()).byteValue());
        properties.setDictionarySizeProperty(((Integer)((DWordSpec)this.dictionarySize.get()).get()).intValue());
        properties.setDecodedSizeProperty(((Long)((QWordSpec)this.uncompressedSize.get()).get()).longValue());
        return InputDecoderTable.build(new LzmaInputDecoder(properties));
    }

    static {
        MANGLED_EXTENSION_MAP.put("tlz", ".tar");
    }
}

