/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.hfsplus;

import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.DWordArraySpec;
import de.carne.filescanner.engine.format.DWordSpec;
import de.carne.filescanner.engine.format.EncodedInputSpecConfig;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.QWordSpec;
import de.carne.filescanner.engine.input.DecodedInputMapper;
import de.carne.filescanner.engine.input.InputDecoderTable;
import de.carne.filescanner.engine.input.InputDecoders;
import de.carne.filescanner.engine.util.IntHelper;
import de.carne.filescanner.provider.hfsplus.HfsPlusInputMapper;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.Objects;

final class HfsPlusFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> hfsPlusFormatSpec = this.resolveLazy("HFSPLUS_DISK_IMAGE", CompositeSpec.class);
    private Lazy<CompositeSpec> hfsPlusHeaderSpec = this.resolveLazy("IMAGE_HEADER", CompositeSpec.class);
    private Lazy<DWordSpec> blockSize = this.resolveLazy("BLOCK_SIZE", DWordSpec.class);
    private Lazy<DWordSpec> totalBlocks = this.resolveLazy("TOTAL_BLOCKS", DWordSpec.class);
    private Lazy<QWordSpec> extentsLogicalSize = this.resolveLazy("EXTENTS_LOGICAL_SIZE", QWordSpec.class);
    private Lazy<DWordArraySpec> extentsExtents = this.resolveLazy("EXTENTS_EXTENTS", DWordArraySpec.class);
    private Lazy<QWordSpec> catalogLogicalSize = this.resolveLazy("CATALOG_LOGICAL_SIZE", QWordSpec.class);
    private Lazy<DWordArraySpec> catalogExtents = this.resolveLazy("CATALOG_EXTENTS", DWordArraySpec.class);

    HfsPlusFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("HfsPlus.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.hfsPlusFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.hfsPlusHeaderSpec.get();
    }

    public EncodedInputSpecConfig hfsplusEncodedInputConfig() {
        return new EncodedInputSpecConfig("disk image blocks").decodedInputMapper(this::decodedInputMapper).inputDecoderTable(this::inputDecoderTable);
    }

    private DecodedInputMapper decodedInputMapper() {
        return new HfsPlusInputMapper(((Integer)((DWordSpec)this.blockSize.get()).get()).intValue(), (Long)((QWordSpec)this.extentsLogicalSize.get()).get(), (int[])((DWordArraySpec)this.extentsExtents.get()).get(), (Long)((QWordSpec)this.catalogLogicalSize.get()).get(), (int[])((DWordArraySpec)this.catalogExtents.get()).get());
    }

    private InputDecoderTable inputDecoderTable() {
        long blockSizeValue = IntHelper.toUnsignedLong((Number)((DWordSpec)this.blockSize.get()).get());
        long totalBlocksValue = IntHelper.toUnsignedLong((Number)((DWordSpec)this.totalBlocks.get()).get());
        long totalBlockSize = blockSizeValue != 0L ? totalBlocksValue * blockSizeValue - 2560L : 0L;
        return InputDecoderTable.build(InputDecoders.IDENTITY, 0L, totalBlockSize, totalBlockSize);
    }
}

