/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.hfsplus;

import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.filescanner.engine.input.MappedFileScannerInput;
import de.carne.filescanner.engine.util.HexFormat;
import de.carne.filescanner.provider.hfsplus.BlockDevice;
import de.carne.filescanner.provider.hfsplus.ExtentsFile;
import java.io.IOException;
import org.eclipse.jdt.annotation.Nullable;

final class ForkData {
    public static final byte DATA_FORK = 0;
    public static final byte RESOURCE_FORK = -1;
    private final BlockDevice blockDevice;
    private final int fileId;
    private final byte forkType;
    private final long logicalSize;
    private final long[] extents;
    private final @Nullable ExtentsFile extentsFile;

    public ForkData(BlockDevice blockDevice, int fileId, byte forkType, long logicalSize, int[] extents, @Nullable ExtentsFile extentsFile) {
        this.blockDevice = blockDevice;
        this.fileId = fileId;
        this.forkType = forkType;
        this.logicalSize = logicalSize;
        this.extents = new long[extents.length];
        for (int extentIndex = 0; extentIndex < extents.length; ++extentIndex) {
            this.extents[extentIndex] = Integer.toUnsignedLong(extents[extentIndex]);
        }
        this.extentsFile = extentsFile;
    }

    public BlockDevice blockDevice() {
        return this.blockDevice;
    }

    public long logicalSize() {
        return this.logicalSize;
    }

    public long position(long offset) throws IOException {
        long position = 0L;
        long remainingOffset = offset;
        while (position == 0L) {
            long currentBlock = this.blockDevice.block(offset - remainingOffset);
            long[] currentExtents = this.getExtents(currentBlock);
            for (int extentIndex = 0; extentIndex < currentExtents.length && position == 0L; extentIndex += 2) {
                long startBlock = currentExtents[extentIndex];
                long blockCount = currentExtents[extentIndex + 1];
                if (startBlock == 0L && blockCount == 0L) {
                    throw new IOException("Invalid fork data offset: " + HexFormat.formatLong(offset));
                }
                long extentStart = this.blockDevice.offset(startBlock);
                long extentSize = this.blockDevice.size(blockCount);
                if (remainingOffset < extentSize) {
                    position = extentStart + remainingOffset;
                    continue;
                }
                remainingOffset -= extentSize;
            }
        }
        return position;
    }

    private long[] getExtents(long startBlock) throws IOException {
        long[] foundExtents;
        if (startBlock == 0L) {
            foundExtents = this.extents;
        } else if (this.extentsFile != null) {
            foundExtents = this.extentsFile.getExtents(this.fileId, this.forkType, startBlock);
        } else {
            throw new IOException("Invalid fork data block: " + startBlock);
        }
        return foundExtents;
    }

    public FileScannerInput map(String name) throws IOException {
        MappedFileScannerInput mappedInput = new MappedFileScannerInput(name);
        long inputSize = 0L;
        block0: while (inputSize < this.logicalSize) {
            long mapSize;
            long currentBlock = this.blockDevice.block(inputSize);
            long[] currentExtents = this.getExtents(currentBlock);
            for (int extentIndex = 0; extentIndex < currentExtents.length && inputSize < this.logicalSize; inputSize += mapSize, extentIndex += 2) {
                long startBlock = currentExtents[extentIndex];
                long blockCount = currentExtents[extentIndex + 1];
                if (startBlock == 0L && blockCount == 0L) continue block0;
                long extentStart = this.blockDevice.offset(startBlock);
                long extentSize = this.blockDevice.size(blockCount);
                mapSize = Math.min(extentSize, this.logicalSize - inputSize);
                mappedInput.add(this.blockDevice.input(), extentStart, extentStart + mapSize);
            }
        }
        return mappedInput;
    }
}

