/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.hfsplus;

import de.carne.filescanner.provider.hfsplus.BTreeFile;
import de.carne.filescanner.provider.hfsplus.ExtentsFileKey;
import de.carne.filescanner.provider.hfsplus.ForkData;
import java.io.IOException;
import java.nio.ByteBuffer;

class ExtentsFile
extends BTreeFile<ExtentsFileKey> {
    public ExtentsFile(ForkData forkData) {
        super(forkData);
    }

    public long[] getExtents(int fileId, byte forkType, long startBlock) throws IOException {
        ExtentsFileKey key = new ExtentsFileKey(forkType, fileId, startBlock);
        ByteBuffer value = this.findLeafNode(key);
        long[] extents = new long[16];
        for (int extentIndex = 0; extentIndex < extents.length; ++extentIndex) {
            extents[extentIndex] = Integer.toUnsignedLong(value.getInt());
        }
        return extents;
    }

    @Override
    protected ExtentsFileKey decodeNodeKey(ByteBuffer keyBuffer) throws IOException {
        byte forkType = keyBuffer.get();
        keyBuffer.get();
        int fileId = keyBuffer.getInt();
        int startBlock = keyBuffer.getInt();
        return new ExtentsFileKey(forkType, fileId, startBlock);
    }
}

