/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.gzip;

import de.carne.filescanner.engine.FileScannerResultContextValueSpecs;
import de.carne.filescanner.engine.format.ByteSpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.EncodedInputSpecConfig;
import de.carne.filescanner.engine.format.FormatSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.format.StringSpec;
import de.carne.filescanner.engine.input.InputDecoderTable;
import de.carne.filescanner.engine.util.ByteHelper;
import de.carne.filescanner.engine.util.DeflateInputDecoder;
import de.carne.nio.file.FileUtil;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class GzipFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> gzipFormatSpec = this.resolveLazy("GZIP_ARCHIVE", CompositeSpec.class);
    private Lazy<CompositeSpec> gzipHeaderSpec = this.resolveLazy("GZIP_HEADER", CompositeSpec.class);
    private Lazy<FormatSpec> gzipFextraSpec = this.resolveLazy("GZIP_HEADER_FEXTRA", FormatSpec.class);
    private Lazy<FormatSpec> gzipFnameSpec = this.resolveLazy("GZIP_HEADER_FNAME", FormatSpec.class);
    private Lazy<FormatSpec> gzipFcommentSpec = this.resolveLazy("GZIP_HEADER_FCOMMENT", FormatSpec.class);
    private Lazy<FormatSpec> gzipFhcrcSpec = this.resolveLazy("GZIP_HEADER_FHCRC", FormatSpec.class);
    private Lazy<ByteSpec> gzipHeaderFlg = this.resolveLazy("HEADER_FLG", ByteSpec.class);
    private Lazy<StringSpec> gzipHeaderFname = this.resolveLazy("HEADER_FNAME", StringSpec.class);
    private static final Map<String, String> MANGLED_EXTENSION_MAP = new HashMap<String, String>();

    GzipFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("Gzip.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.gzipFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.gzipHeaderSpec.get();
    }

    public FormatSpec fextraSpec() {
        int flg = ByteHelper.toUnsignedInt((Number)((ByteSpec)this.gzipHeaderFlg.get()).get());
        return (flg & 4) == 4 ? (FormatSpec)this.gzipFextraSpec.get() : FormatSpecs.EMPTY;
    }

    public FormatSpec fnameSpec() {
        int flg = ByteHelper.toUnsignedInt((Number)((ByteSpec)this.gzipHeaderFlg.get()).get());
        return (flg & 8) == 8 ? (FormatSpec)this.gzipFnameSpec.get() : FormatSpecs.EMPTY;
    }

    public FormatSpec fcommentSpec() {
        int flg = ByteHelper.toUnsignedInt((Number)((ByteSpec)this.gzipHeaderFlg.get()).get());
        return (flg & 0x10) == 16 ? (FormatSpec)this.gzipFcommentSpec.get() : FormatSpecs.EMPTY;
    }

    public FormatSpec fhcrcSpec() {
        int flg = ByteHelper.toUnsignedInt((Number)((ByteSpec)this.gzipHeaderFlg.get()).get());
        return (flg & 2) == 2 ? (FormatSpec)this.gzipFhcrcSpec.get() : FormatSpecs.EMPTY;
    }

    public EncodedInputSpecConfig gzipEncodedInputConfig() {
        return new EncodedInputSpecConfig("Compressed data").decodedInputName(this::decodedInputName).inputDecoderTable(this::inputDecoderTable);
    }

    private String decodedInputName() {
        int flg = ByteHelper.toUnsignedInt((Number)((ByteSpec)this.gzipHeaderFlg.get()).get());
        StringBuilder decodedInputName = new StringBuilder();
        if ((flg & 8) == 8) {
            decodedInputName.append((String)((StringSpec)this.gzipHeaderFname.get()).get());
        } else {
            String[] splitInputName = FileUtil.splitPath((String)((String)FileScannerResultContextValueSpecs.INPUT_NAME.get()));
            decodedInputName.append(splitInputName[1]);
            decodedInputName.append(MANGLED_EXTENSION_MAP.getOrDefault(splitInputName[2], ""));
        }
        return decodedInputName.toString();
    }

    private InputDecoderTable inputDecoderTable() {
        return InputDecoderTable.build(new DeflateInputDecoder());
    }

    static {
        MANGLED_EXTENSION_MAP.put("tgz", ".tar");
    }
}

