/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.gif;

import de.carne.filescanner.engine.format.ByteSpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.handler.RawTransferHandler;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.Objects;

final class GifFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> gifFormatSpec = this.resolveLazy("GIF_FORMAT", CompositeSpec.class);
    private Lazy<CompositeSpec> gifHeaderSpec = this.resolveLazy("GIF_HEADER", CompositeSpec.class);
    private Lazy<CompositeSpec> gifGlobalColorTableSpec = this.resolveLazy("GIF_GLOBAL_COLOR_TABLE", CompositeSpec.class);
    private Lazy<CompositeSpec> gifLocalColorTableSpec = this.resolveLazy("GIF_LOCAL_COLOR_TABLE", CompositeSpec.class);
    private Lazy<ByteSpec> lsdPackedFields = this.resolveLazy("LSD_PACKED_FIELDS", ByteSpec.class);
    private Lazy<ByteSpec> imagePackedFields = this.resolveLazy("IMAGE_PACKED_FIELDS", ByteSpec.class);

    GifFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("GIF.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.gifFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.gifHeaderSpec.get();
    }

    public FileScannerResultRenderHandler gifRenderer() {
        return RawTransferHandler.IMAGE_GIF_TRANSFER;
    }

    public FileScannerResultExportHandler gifExporter() {
        return RawTransferHandler.IMAGE_GIF_TRANSFER;
    }

    public CompositeSpec globalColorTableSpec() {
        CompositeSpec globalColorTableSpec = FormatSpecs.EMPTY;
        int packedFields = (Byte)((ByteSpec)this.lsdPackedFields.get()).get() & 0xFF;
        if ((packedFields & 0x80) == 128) {
            globalColorTableSpec = (CompositeSpec)this.gifGlobalColorTableSpec.get();
        }
        return globalColorTableSpec;
    }

    public Integer globalColorTableSize() {
        int packedFields = (Byte)((ByteSpec)this.lsdPackedFields.get()).get() & 0xFF;
        return 2 << (packedFields & 7);
    }

    public CompositeSpec localColorTableSpec() {
        CompositeSpec localColorTableSpec = FormatSpecs.EMPTY;
        int packedFields = (Byte)((ByteSpec)this.imagePackedFields.get()).get() & 0xFF;
        if ((packedFields & 0x80) == 128) {
            localColorTableSpec = (CompositeSpec)this.gifLocalColorTableSpec.get();
        }
        return localColorTableSpec;
    }

    public Integer localColorTableSize() {
        int packedFields = (Byte)((ByteSpec)this.imagePackedFields.get()).get() & 0xFF;
        return 2 << (packedFields & 7);
    }
}

