/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.cpio;

import de.carne.filescanner.engine.format.CharArraySpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.EncodedInputSpecConfig;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.input.InputDecoderTable;
import de.carne.filescanner.engine.input.InputDecoders;
import de.carne.filescanner.engine.util.Alignment;
import de.carne.filescanner.engine.util.HexStrings;
import de.carne.filescanner.engine.util.OctalStrings;
import de.carne.filescanner.engine.util.PrettyFormat;
import de.carne.filescanner.engine.util.SizeRenderer;
import de.carne.filescanner.engine.util.Unix;
import de.carne.filescanner.engine.util.UnixDateRenderer;
import de.carne.util.Lazy;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;

final class CpioFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> cpioFormatSpec = this.resolveLazy("CPIO_ARCHIVE", CompositeSpec.class);
    private Lazy<CompositeSpec> cpioHeaderSpec = this.resolveLazy("CPIO_ENTRY", CompositeSpec.class);
    private Lazy<CharArraySpec> odcNameSize = this.resolveLazy("ODC_NAME_SIZE", CharArraySpec.class);
    private Lazy<CharArraySpec> odcFileSize = this.resolveLazy("ODC_FILE_SIZE", CharArraySpec.class);
    private Lazy<CharArraySpec> odcPathName = this.resolveLazy("ODC_PATH_NAME", CharArraySpec.class);
    private Lazy<CharArraySpec> newcNameSize = this.resolveLazy("NEWC_NAME_SIZE", CharArraySpec.class);
    private Lazy<CharArraySpec> newcFileSize = this.resolveLazy("NEWC_FILE_SIZE", CharArraySpec.class);
    private Lazy<CharArraySpec> newcPathName = this.resolveLazy("NEWC_PATH_NAME", CharArraySpec.class);

    public CpioFormatSpecDefinition() {
        this.addStringAttributeRenderer("OCTAL_PRETTY", OctalStrings.intRenderer(PrettyFormat.INT_FORMATTER));
        this.addStringAttributeRenderer("OCTAL_SIZE", OctalStrings.intRenderer(SizeRenderer.INT_RENDERER));
        this.addStringAttributeRenderer("OCTAL_DATE", OctalStrings.intRenderer(UnixDateRenderer.RENDERER));
        this.addStringAttributeRenderer("OCTAL_MODE", OctalStrings.intRenderer(CpioFormatSpecDefinition::formatMode));
        this.addStringAttributeRenderer("HEX_PRETTY", HexStrings.longRenderer(PrettyFormat.LONG_FORMATTER));
        this.addStringAttributeRenderer("HEX_SIZE", HexStrings.longRenderer(SizeRenderer.LONG_RENDERER));
        this.addStringAttributeRenderer("HEX_DATE", HexStrings.intRenderer(UnixDateRenderer.RENDERER));
        this.addStringAttributeRenderer("HEX_MODE", HexStrings.intRenderer(CpioFormatSpecDefinition::formatMode));
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("Cpio.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.cpioFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.cpioHeaderSpec.get();
    }

    public Integer odcNameSize() throws IOException {
        String nameSizeString = (String)((CharArraySpec)this.odcNameSize.get()).get();
        return OctalStrings.parseInt(nameSizeString);
    }

    public EncodedInputSpecConfig odcEncodedInputConfig() {
        return new EncodedInputSpecConfig("data").decodedInputName(((CharArraySpec)this.odcPathName.get())::getStripped).inputDecoderTable(this::odcInputDecoderTable);
    }

    private InputDecoderTable odcInputDecoderTable() {
        String fileSizeString = (String)((CharArraySpec)this.odcFileSize.get()).get();
        long fileSize = OctalStrings.safeParseLong(fileSizeString);
        return InputDecoderTable.build(InputDecoders.IDENTITY, -1L, fileSize, -1L);
    }

    public Integer newcNameSize() throws IOException {
        String nameSizeString = (String)((CharArraySpec)this.newcNameSize.get()).get();
        int nameSize = HexStrings.parseInt(nameSizeString);
        return Alignment.dword(2, nameSize);
    }

    public EncodedInputSpecConfig newcEncodedInputConfig() {
        return new EncodedInputSpecConfig("data").decodedInputName(((CharArraySpec)this.newcPathName.get())::getStripped).inputDecoderTable(this::newcInputDecoderTable);
    }

    private InputDecoderTable newcInputDecoderTable() {
        String fileSizeString = (String)((CharArraySpec)this.newcFileSize.get()).get();
        long fileSize = HexStrings.safeParseLong(fileSizeString);
        return InputDecoderTable.build(InputDecoders.IDENTITY, -1L, Alignment.dword(fileSize), fileSize);
    }

    private static String formatMode(Integer mode) {
        char type;
        int modeValue = mode;
        switch (modeValue & 0xF000) {
            case 4096: {
                type = 'p';
                break;
            }
            case 8192: {
                type = 'c';
                break;
            }
            case 16384: {
                type = 'd';
                break;
            }
            case 24576: {
                type = 'b';
                break;
            }
            case 32768: {
                type = '-';
                break;
            }
            case 40960: {
                type = 'l';
                break;
            }
            case 49152: {
                type = 's';
                break;
            }
            default: {
                type = '?';
            }
        }
        return Unix.formatMode(type, modeValue);
    }
}

