/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.bzip2;

import de.carne.filescanner.engine.FileScannerResultContextValueSpecs;
import de.carne.filescanner.engine.format.ByteSpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.EncodedInputSpecConfig;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.input.InputDecoderTable;
import de.carne.filescanner.engine.util.Bzip2InputDecoder;
import de.carne.nio.compression.bzip2.Bzip2BlockSize;
import de.carne.nio.compression.bzip2.Bzip2DecoderProperties;
import de.carne.nio.file.FileUtil;
import de.carne.util.Check;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class Bzip2FormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> bzip2FormatSpec = this.resolveLazy("BZIP2_ARCHIVE", CompositeSpec.class);
    private Lazy<CompositeSpec> bzip2HeaderSpec = this.resolveLazy("BZIP2_HEADER", CompositeSpec.class);
    private Lazy<ByteSpec> bzip2BlockSize = this.resolveLazy("BLOCK_SIZE", ByteSpec.class);
    private static final Map<String, String> MANGLED_EXTENSION_MAP = new HashMap<String, String>();

    Bzip2FormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("Bzip2.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.bzip2FormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.bzip2HeaderSpec.get();
    }

    public EncodedInputSpecConfig bzip2EncodedInputConfig() {
        return new EncodedInputSpecConfig("Compressed data").decodedInputName(this::decodedInputName).inputDecoderTable(this::inputDecoderTable);
    }

    private String decodedInputName() {
        String[] splitInputName = FileUtil.splitPath((String)((String)FileScannerResultContextValueSpecs.INPUT_NAME.get()));
        return splitInputName[1] + MANGLED_EXTENSION_MAP.getOrDefault(splitInputName[2], "");
    }

    private InputDecoderTable inputDecoderTable() {
        Bzip2DecoderProperties properties = Bzip2InputDecoder.defaultProperties();
        byte blockSize = (Byte)((ByteSpec)this.bzip2BlockSize.get()).get();
        switch (blockSize) {
            case 49: {
                properties.setBlockSizeProperty(Bzip2BlockSize.SIZE1);
                break;
            }
            case 50: {
                properties.setBlockSizeProperty(Bzip2BlockSize.SIZE2);
                break;
            }
            case 51: {
                properties.setBlockSizeProperty(Bzip2BlockSize.SIZE3);
                break;
            }
            case 52: {
                properties.setBlockSizeProperty(Bzip2BlockSize.SIZE4);
                break;
            }
            case 53: {
                properties.setBlockSizeProperty(Bzip2BlockSize.SIZE5);
                break;
            }
            case 54: {
                properties.setBlockSizeProperty(Bzip2BlockSize.SIZE6);
                break;
            }
            case 55: {
                properties.setBlockSizeProperty(Bzip2BlockSize.SIZE7);
                break;
            }
            case 56: {
                properties.setBlockSizeProperty(Bzip2BlockSize.SIZE8);
                break;
            }
            case 57: {
                properties.setBlockSizeProperty(Bzip2BlockSize.SIZE9);
                break;
            }
            default: {
                throw Check.fail((String)"Unexpected block size: %x", (Object[])new Object[]{blockSize});
            }
        }
        return InputDecoderTable.build(new Bzip2InputDecoder(properties));
    }

    static {
        MANGLED_EXTENSION_MAP.put("tb2", ".tar");
        MANGLED_EXTENSION_MAP.put("tbz", ".tar");
        MANGLED_EXTENSION_MAP.put("tbz2", ".tar");
    }
}

