/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.bmp;

import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.DWordSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.format.WordSpec;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.handler.RawTransferHandler;
import de.carne.filescanner.engine.util.IntHelper;
import de.carne.filescanner.engine.util.ShortHelper;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.Objects;

final class BmpFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> bmpFormatSpec = this.resolveLazy("BMP_FORMAT", CompositeSpec.class);
    private Lazy<CompositeSpec> bmpHeaderSpec = this.resolveLazy("BMP_FILE_HEADER", CompositeSpec.class);
    private Lazy<CompositeSpec> bitFieldsSpec = this.resolveLazy("BIT_FIELDS", CompositeSpec.class);
    private Lazy<CompositeSpec> rgbQuadColorTableSpec = this.resolveLazy("RGB_QUAD_COLOR_TABLE", CompositeSpec.class);
    private Lazy<DWordSpec> biWidth = this.resolveLazy("BI_WIDTH", DWordSpec.class);
    private Lazy<DWordSpec> biHeight = this.resolveLazy("BI_HEIGHT", DWordSpec.class);
    private Lazy<WordSpec> biBitCount = this.resolveLazy("BI_BIT_COUNT", WordSpec.class);
    private Lazy<DWordSpec> biCompression = this.resolveLazy("BI_COMPRESSION", DWordSpec.class);
    private Lazy<DWordSpec> biSizeImage = this.resolveLazy("BI_SIZE_IMAGE", DWordSpec.class);
    private Lazy<DWordSpec> biClrUsed = this.resolveLazy("BI_CLR_USED", DWordSpec.class);

    BmpFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("BMP.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.bmpFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.bmpHeaderSpec.get();
    }

    public FileScannerResultRenderHandler bmpRenderer() {
        return RawTransferHandler.IMAGE_BMP_TRANSFER;
    }

    public FileScannerResultExportHandler bmpExporter() {
        return RawTransferHandler.IMAGE_BMP_TRANSFER;
    }

    public CompositeSpec colorTableSpec() {
        CompositeSpec colorTableSpec = FormatSpecs.EMPTY;
        if ((Integer)((DWordSpec)this.biCompression.get()).get() == 3) {
            colorTableSpec = (CompositeSpec)this.bitFieldsSpec.get();
        } else if ((Short)((WordSpec)this.biBitCount.get()).get() <= 8) {
            colorTableSpec = (CompositeSpec)this.rgbQuadColorTableSpec.get();
        }
        return colorTableSpec;
    }

    public Integer colorTableSize() {
        int colorTableSize = (Integer)((DWordSpec)this.biClrUsed.get()).get();
        if (colorTableSize == 0) {
            colorTableSize = 2 << ShortHelper.toUnsignedInt((Number)((WordSpec)this.biBitCount.get()).get());
        }
        return colorTableSize;
    }

    public Long imageSize() {
        long imageSize = IntHelper.toUnsignedLong((Number)((DWordSpec)this.biSizeImage.get()).get());
        if (imageSize == 0L) {
            long biWidthValue = ((Integer)((DWordSpec)this.biWidth.get()).get()).intValue();
            long biHeightValue = Math.abs((Integer)((DWordSpec)this.biHeight.get()).get());
            short biBitCountValue = (Short)((WordSpec)this.biBitCount.get()).get();
            imageSize = (biWidthValue * (long)biBitCountValue + 31L >> 5 << 2) * biHeightValue;
        }
        return imageSize;
    }
}

