/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public final class Unix {
    private Unix() {
    }

    public static LocalDateTime unixDateToLocalDateTime(int date) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(Integer.toUnsignedLong(date) * 1000L), ZoneId.of("UTC"));
    }

    public static String formatMode(char type, int mode) {
        char[] modeChars = new char[]{type, 'r', 'w', 'x', 'r', 'w', 'x', 'r', 'w', 'x'};
        int permission = 256;
        for (int modeCharIndex = 1; modeCharIndex < modeChars.length; ++modeCharIndex) {
            if ((mode & permission) == 0) {
                modeChars[modeCharIndex] = 45;
            }
            permission >>= 1;
        }
        if ((mode & 0x800) != 0) {
            int n = modeChars[3] = modeChars[3] != '-' ? 115 : 83;
        }
        if ((mode & 0x400) != 0) {
            int n = modeChars[6] = modeChars[6] != '-' ? 115 : 83;
        }
        if ((mode & 0x200) != 0) {
            modeChars[9] = modeChars[9] != '-' ? 116 : 84;
        }
        return new String(modeChars);
    }
}

