/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.util;

import de.carne.filescanner.engine.format.AttributeRenderer;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.text.MemoryUnitFormat;
import java.io.IOException;

public final class SizeRenderer {
    public static final AttributeRenderer<Byte> BYTE_RENDERER = SizeRenderer::renderByteSize;
    public static final AttributeRenderer<Short> SHORT_RENDERER = SizeRenderer::renderShortSize;
    public static final AttributeRenderer<Integer> INT_RENDERER = SizeRenderer::renderIntSize;
    public static final AttributeRenderer<Long> LONG_RENDERER = SizeRenderer::renderLongSize;

    private SizeRenderer() {
    }

    public static void renderByteSize(RenderOutput out, byte value) throws IOException {
        out.setStyle(RenderStyle.COMMENT).write(" // ").write(MemoryUnitFormat.getMemoryUnitInstance().format((double)(value & 0xFF) * 1.0));
    }

    public static void renderShortSize(RenderOutput out, short value) throws IOException {
        out.setStyle(RenderStyle.COMMENT).write(" // ").write(MemoryUnitFormat.getMemoryUnitInstance().format((double)(value & 0xFFFF) * 1.0));
    }

    public static void renderIntSize(RenderOutput out, int value) throws IOException {
        out.setStyle(RenderStyle.COMMENT).write(" // ").write(MemoryUnitFormat.getMemoryUnitInstance().format((double)((long)value & 0xFFFFFFFFL) * 1.0));
    }

    public static void renderLongSize(RenderOutput out, long value) throws IOException {
        out.setStyle(RenderStyle.COMMENT).write(" // ").write(MemoryUnitFormat.getMemoryUnitInstance().format((double)value * 1.0));
    }
}

