/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.util;

import de.carne.filescanner.engine.format.AttributeFormatter;
import de.carne.filescanner.engine.util.StringHelper;
import de.carne.util.Strings;
import java.text.NumberFormat;

public final class PrettyFormat {
    public static final AttributeFormatter<Byte> BYTE_CHAR_FORMATTER = PrettyFormat::formatByteChar;
    public static final AttributeFormatter<Byte> BYTE_FORMATTER = PrettyFormat::formatByteNumber;
    public static final AttributeFormatter<byte[]> BYTE_ARRAY_FORMATTER = PrettyFormat::formatByteNumberArray;
    public static final AttributeFormatter<Short> SHORT_FORMATTER = PrettyFormat::formatShortNumber;
    public static final AttributeFormatter<short[]> SHORT_ARRAY_FORMATTER = PrettyFormat::formatShortNumberArray;
    public static final AttributeFormatter<Integer> INT_FORMATTER = PrettyFormat::formatIntNumber;
    public static final AttributeFormatter<int[]> INT_ARRAY_FORMATTER = PrettyFormat::formatIntNumberArray;
    public static final AttributeFormatter<Long> LONG_FORMATTER = PrettyFormat::formatLongNumber;
    public static final AttributeFormatter<long[]> LONG_ARRAY_FORMATTER = PrettyFormat::formatLongNumberArray;
    public static final AttributeFormatter<String> STRING_FORMATTER = PrettyFormat::formatString;

    private PrettyFormat() {
    }

    public static String formatByteChar(byte value) {
        return "'" + Strings.encode((CharSequence)String.valueOf((char)value)) + "'";
    }

    public static String formatByteNumber(byte value) {
        return NumberFormat.getNumberInstance().format((long)value & 0xFFL);
    }

    public static String formatByteNumberArray(byte[] value) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        boolean firstElement = true;
        for (byte valueElement : value) {
            if (firstElement) {
                firstElement = false;
                buffer.append(' ');
            } else {
                buffer.append(", ");
            }
            buffer.append(PrettyFormat.formatByteNumber(valueElement));
        }
        buffer.append(" }");
        return buffer.toString();
    }

    public static String formatShortNumber(short value) {
        return NumberFormat.getNumberInstance().format((long)value & 0xFFFFL);
    }

    public static String formatShortNumberArray(short[] value) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        boolean firstElement = true;
        for (short valueElement : value) {
            if (firstElement) {
                firstElement = false;
                buffer.append(' ');
            } else {
                buffer.append(", ");
            }
            buffer.append(PrettyFormat.formatShortNumber(valueElement));
        }
        buffer.append(" }");
        return buffer.toString();
    }

    public static String formatIntNumber(int value) {
        return NumberFormat.getNumberInstance().format((long)value & 0xFFFFFFFFL);
    }

    public static String formatIntNumberArray(int[] value) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        boolean firstElement = true;
        for (int valueElement : value) {
            if (firstElement) {
                firstElement = false;
                buffer.append(' ');
            } else {
                buffer.append(", ");
            }
            buffer.append(PrettyFormat.formatIntNumber(valueElement));
        }
        buffer.append(" }");
        return buffer.toString();
    }

    public static String formatLongNumber(long value) {
        return NumberFormat.getNumberInstance().format(value);
    }

    public static String formatLongNumberArray(long[] value) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        boolean firstElement = true;
        for (long valueElement : value) {
            if (firstElement) {
                firstElement = false;
                buffer.append(' ');
            } else {
                buffer.append(", ");
            }
            buffer.append(PrettyFormat.formatLongNumber(valueElement));
        }
        buffer.append(" }");
        return buffer.toString();
    }

    public static StringBuilder formatString(StringBuilder buffer, String value) {
        buffer.append("\"");
        Strings.encode((StringBuilder)buffer, (CharSequence)StringHelper.strip(value));
        buffer.append('\"');
        return buffer;
    }

    public static String formatString(String value) {
        return PrettyFormat.formatString(new StringBuilder(), value).toString();
    }
}

