/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.util;

import de.carne.filescanner.engine.format.AttributeFormatter;
import de.carne.filescanner.engine.format.AttributeRenderer;
import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.util.Exceptions;
import de.carne.util.Strings;
import de.carne.util.function.FunctionException;
import java.io.IOException;
import java.util.function.IntConsumer;

public final class HexStrings {
    private HexStrings() {
    }

    public static int parseInt(String s) throws IOException {
        IntValueParser parser = new IntValueParser(s);
        try {
            s.chars().forEachOrdered(parser);
        }
        catch (FunctionException e) {
            throw (IOException)e.rethrow(IOException.class);
        }
        return parser.value();
    }

    public static int safeParseInt(String s) {
        IntValueParser parser = new IntValueParser(s);
        try {
            s.chars().forEachOrdered(parser);
        }
        catch (FunctionException e) {
            Exceptions.ignore((Throwable)e.rethrow(IOException.class));
        }
        return parser.value();
    }

    public static AttributeRenderer<String> intRenderer(AttributeRenderer<Integer> renderer) {
        return (out, value) -> renderer.render(out, HexStrings.safeParseInt(value));
    }

    public static AttributeRenderer<String> intRenderer(AttributeFormatter<Integer> formatter) {
        return (out, value) -> out.setStyle(RenderStyle.COMMENT).write("// ").write(formatter.format(HexStrings.safeParseInt(value)));
    }

    public static long parseLong(String s) throws IOException {
        LongValueParser parser = new LongValueParser(s);
        try {
            s.chars().forEachOrdered(parser);
        }
        catch (FunctionException e) {
            throw (IOException)e.rethrow(IOException.class);
        }
        return parser.value();
    }

    public static long safeParseLong(String s) {
        LongValueParser parser = new LongValueParser(s);
        try {
            s.chars().forEachOrdered(parser);
        }
        catch (FunctionException e) {
            Exceptions.ignore((Throwable)e.rethrow(IOException.class));
        }
        return parser.value();
    }

    public static AttributeRenderer<String> longRenderer(AttributeRenderer<Long> renderer) {
        return (out, value) -> renderer.render(out, HexStrings.safeParseLong(value));
    }

    public static AttributeRenderer<String> longRenderer(AttributeFormatter<Long> formatter) {
        return (out, value) -> out.setStyle(RenderStyle.COMMENT).write("// ").write(formatter.format(HexStrings.safeParseLong(value)));
    }

    private static class LongValueParser
    extends ValueParser {
        private long parsedValue = 0L;

        LongValueParser(String s) {
            super(s);
        }

        public long value() {
            return this.parsedValue;
        }

        @Override
        protected void shift(int value) {
            if ((this.parsedValue & 0xF000000000000000L) != 0L) {
                throw new FunctionException((Exception)new IOException("Octal string exceeds long limit: \"" + Strings.encode((CharSequence)this.s) + "\""));
            }
            this.parsedValue = this.parsedValue << 4 | (long)value;
        }
    }

    private static class IntValueParser
    extends ValueParser {
        private int parsedValue = 0;

        IntValueParser(String s) {
            super(s);
        }

        public int value() {
            return this.parsedValue;
        }

        @Override
        protected void shift(int value) {
            if ((this.parsedValue & 0xF0000000) != 0) {
                throw new FunctionException((Exception)new IOException("Octal string exceeds integer limit: \"" + Strings.encode((CharSequence)this.s) + "\""));
            }
            this.parsedValue = this.parsedValue << 4 | value;
        }
    }

    private static abstract class ValueParser
    implements IntConsumer {
        protected final String s;
        private int pos = 0;
        private boolean eos = false;

        protected ValueParser(String s) {
            this.s = s;
        }

        @Override
        public void accept(int value) {
            if (value == 0) {
                this.eos = true;
            } else {
                if (this.eos) {
                    throw new FunctionException((Exception)new IOException("Unexpected trailing char: \"" + Strings.encode((CharSequence)this.s) + "\"[" + this.pos + "]"));
                }
                if (48 <= value && value <= 57) {
                    this.shift(value - 48);
                } else if (97 <= value && value <= 102) {
                    this.shift(10 + value - 97);
                } else if (65 <= value && value <= 70) {
                    this.shift(10 + value - 65);
                } else {
                    throw new FunctionException((Exception)new IOException("Unexpected octal char: \"" + Strings.encode((CharSequence)this.s) + "\"[" + this.pos + "]"));
                }
            }
            ++this.pos;
        }

        protected abstract void shift(int var1);
    }
}

