/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.util;

import de.carne.util.Exceptions;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;

public final class Dos {
    private static final LocalTime DEFAULT_LOCAL_TIME = LocalTime.of(0, 0, 0);
    private static final LocalDate DEFAULT_LOCAL_DATE = LocalDate.of(1980, 1, 1);

    private Dos() {
    }

    public static LocalTime dosTimeToLocalTime(short time) {
        LocalTime localTime;
        int hour = (time & 0xFFFF) >>> 11 & 0x1F;
        int minute = (time & 0xFFFF) >>> 5 & 0x3F;
        int second = (time & 0x1F) * 2;
        try {
            localTime = LocalTime.of(hour, minute, second);
        }
        catch (DateTimeException e) {
            Exceptions.warn((Throwable)e);
            localTime = DEFAULT_LOCAL_TIME;
        }
        return localTime;
    }

    public static LocalDate dosDateToLocalDate(short date) {
        LocalDate localDate;
        int year = 1980 + ((date & 0xFFFF) >>> 9 & 0x7F);
        int month = (date & 0xFFFF) >>> 5 & 0xF;
        int day = date & 0x1F;
        try {
            localDate = LocalDate.of(year, month, day);
        }
        catch (DateTimeException e) {
            Exceptions.warn((Throwable)e);
            localDate = DEFAULT_LOCAL_DATE;
        }
        return localDate;
    }
}

