/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.util;

import org.eclipse.jdt.annotation.NonNull;

public final class ByteHelper {
    private ByteHelper() {
    }

    public static byte decodeUnsigned(String string) {
        short value = Short.decode(string);
        if (value > 255) {
            throw new NumberFormatException("Value " + value + " out of range from input " + string);
        }
        return (byte)(value & 0xFF);
    }

    public static byte[] decodeUnsignedArray(@NonNull String[] stringArray) {
        int length = stringArray.length;
        byte[] valueArray = new byte[length];
        for (int index = 0; index < length; ++index) {
            valueArray[index] = ByteHelper.decodeUnsigned(stringArray[index]);
        }
        return valueArray;
    }

    public static int toUnsignedInt(Number byteNumber) {
        int unsignedInt = byteNumber instanceof Byte ? Byte.toUnsignedInt(byteNumber.byteValue()) : (byteNumber instanceof Short ? Short.toUnsignedInt(byteNumber.shortValue()) : byteNumber.intValue());
        if ((unsignedInt & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("Number exceeds byte value range: " + Integer.toHexString(unsignedInt));
        }
        return unsignedInt;
    }
}

