/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.transfer.renderer;

import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.filescanner.engine.transfer.Renderer;
import de.carne.filescanner.engine.transfer.TransferSource;
import java.io.IOException;
import java.io.Writer;

public class PlainTextRenderer
implements Renderer {
    private static final String INDENT = "    ";
    private final Writer writer;
    private final boolean autoClose;

    public PlainTextRenderer(Writer writer) {
        this(writer, true);
    }

    public PlainTextRenderer(Writer writer, boolean autoClose) {
        this.writer = writer;
        this.autoClose = autoClose;
    }

    @Override
    public void close() throws IOException {
        if (this.autoClose) {
            this.writer.close();
        } else {
            this.writer.flush();
        }
    }

    @Override
    public boolean isStyled() {
        return false;
    }

    @Override
    public void emitText(int indent, RenderStyle style, String text, boolean lineBreak) throws IOException {
        this.emitIndent(indent);
        this.writer.write(text);
        this.emitLineBreak(lineBreak);
    }

    @Override
    public void emitMediaData(int indent, RenderStyle style, TransferSource source, boolean lineBreak) throws IOException {
        this.emitIndent(indent);
        this.writer.write("[" + source.transferType().mimeType() + "]");
        this.emitLineBreak(lineBreak);
    }

    private void emitIndent(int indent) throws IOException {
        for (int indentCount = 0; indentCount < indent; ++indentCount) {
            this.writer.write(INDENT);
        }
    }

    private void emitLineBreak(boolean lineBreak) throws IOException {
        if (lineBreak) {
            this.writer.write(System.lineSeparator());
        }
    }

    public String toString() {
        return this.writer.toString();
    }
}

