/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.transfer.handler;

import de.carne.filescanner.engine.FileScannerResult;
import de.carne.filescanner.engine.FileScannerResultRenderContext;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.RenderOption;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.filescanner.engine.transfer.handler.StyledTextCharStream;
import de.carne.filescanner.engine.transfer.renderer.textstyle.PlainStyle;
import de.carne.filescanner.engine.transfer.renderer.textstyle.XMLStyle;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;

public class StyledTextRenderHandler
implements FileScannerResultRenderHandler {
    private static final Style PLAIN_STYLE = Style.withLexer(PlainStyle::new, 1);
    private static final Style XML_STYLE = Style.withLexer(XMLStyle::new, 1).withStyle(2, RenderStyle.COMMENT).withStyle(4, RenderStyle.LABEL).withStyle(5, RenderStyle.LABEL).withStyle(7, RenderStyle.VALUE);
    private final Style style;
    private final Charset charset;
    public static final StyledTextRenderHandler PLAIN_ASCII_RENDER_HANDLER = new StyledTextRenderHandler(PLAIN_STYLE, StandardCharsets.US_ASCII);
    public static final StyledTextRenderHandler PLAIN_ISO8859_RENDER_HANDLER = new StyledTextRenderHandler(PLAIN_STYLE, StandardCharsets.ISO_8859_1);
    public static final StyledTextRenderHandler PLAIN_UTF8_RENDER_HANDLER = new StyledTextRenderHandler(PLAIN_STYLE, StandardCharsets.UTF_8);
    public static final StyledTextRenderHandler PLAIN_UTF16LE_RENDER_HANDLER = new StyledTextRenderHandler(PLAIN_STYLE, StandardCharsets.UTF_16LE);
    public static final StyledTextRenderHandler PLAIN_UTF16BE_RENDER_HANDLER = new StyledTextRenderHandler(PLAIN_STYLE, StandardCharsets.UTF_16BE);
    public static final StyledTextRenderHandler XML_UTF8_RENDER_HANDLER = new StyledTextRenderHandler(XML_STYLE, StandardCharsets.UTF_8);

    public static final StyledTextRenderHandler xmlRenderHandler(Charset charset) {
        return StandardCharsets.UTF_8.equals(charset) ? XML_UTF8_RENDER_HANDLER : new StyledTextRenderHandler(XML_STYLE, charset);
    }

    private StyledTextRenderHandler(Style style, Charset charset) {
        this.style = style;
        this.charset = charset;
    }

    @Override
    public void render(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        out.enableOption(RenderOption.WRAP);
        StyledTextCharStream lexerInput = this.newLexerInput(context);
        Lexer lexer = this.style.lexer(lexerInput);
        while (!lexer._hitEOF) {
            Token token = lexer.nextToken();
            int tokenType = token.getType();
            if (!this.style.isLineBreakTokenType(tokenType)) {
                out.setStyle(this.style.style(tokenType));
                out.write(token.getText());
                continue;
            }
            out.writeln();
        }
        context.skip(lexerInput.decodedBytes());
    }

    private StyledTextCharStream newLexerInput(FileScannerResultRenderContext context) throws IOException {
        FileScannerResult result = context.result();
        SeekableByteChannel channel = result.input().byteChannel(context.position(), result.end());
        return new StyledTextCharStream(channel, context.remaining(), this.charset);
    }

    private static class Style {
        private final Function<CharStream, Lexer> lexerFactory;
        private final int lineBreakTokenType;
        private final Map<Integer, RenderStyle> styleMap = new HashMap<Integer, RenderStyle>();

        private Style(Function<CharStream, Lexer> lexerFactory, int lineBreakTokenType) {
            this.lexerFactory = lexerFactory;
            this.lineBreakTokenType = lineBreakTokenType;
        }

        static Style withLexer(Function<CharStream, Lexer> lexerFactory, int lineBreakType) {
            return new Style(lexerFactory, lineBreakType);
        }

        Style withStyle(int tokenType, RenderStyle style) {
            this.styleMap.put(tokenType, style);
            return this;
        }

        Lexer lexer(CharStream input) {
            return this.lexerFactory.apply(input);
        }

        boolean isLineBreakTokenType(int tokenType) {
            return this.lineBreakTokenType == tokenType;
        }

        RenderStyle style(int tokenType) {
            return this.styleMap.getOrDefault(tokenType, RenderStyle.NORMAL);
        }
    }
}

