/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.transfer.handler;

import de.carne.util.Check;
import de.carne.util.Exceptions;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.jdt.annotation.Nullable;

class StyledTextCharStream
implements CharStream {
    private static final Log LOG = new Log();
    private static final int READ_BUFFER_SIZE = 1024;
    private static final int DECODE_BUFFER_SIZE = 2048;
    private final ReadableByteChannel channel;
    private final long channelSize;
    private boolean channelEof = false;
    private final CharsetDecoder decoder;
    private final ByteBuffer readBuffer = ByteBuffer.allocate(1024).position(1024);
    private CharBuffer decodeBuffer0 = CharBuffer.allocate(2048);
    private int decoded0 = 0;
    private CharBuffer decodeBuffer1 = CharBuffer.allocate(2048);
    private int decoded1 = 0;
    private int decodeBufferDisplacement = 0;
    private int markIndex = -1;
    private long decodedBytes = 0L;

    StyledTextCharStream(ReadableByteChannel channel, long channelSize, Charset charset) {
        this.channel = channel;
        this.channelSize = channelSize;
        this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public long decodedBytes() {
        return this.decodedBytes;
    }

    public void consume() {
        if (this.decodeBuffer0.hasRemaining()) {
            this.decodeBuffer0.get();
        } else {
            this.decodeBuffer1.get();
        }
        this.compactDecodeBuffer();
    }

    public int LA(int i) {
        this.feedDecodeBuffer(i);
        int position0 = this.decodeBuffer0.position();
        int position1 = this.decodeBuffer1.position();
        int lookPosition = position0 + position1 + (i > 0 ? i - 1 : i);
        int symbol = lookPosition < this.decoded0 ? this.decodeBuffer0.get(lookPosition) : (lookPosition - this.decoded0 < this.decoded1 ? (int)this.decodeBuffer1.get(lookPosition - this.decoded0) : -1);
        return symbol;
    }

    public int mark() {
        int marker = this.markIndex;
        this.markIndex = this.index();
        return marker;
    }

    public void release(int marker) {
        this.markIndex = marker;
    }

    public int index() {
        return this.decodeBufferDisplacement + this.decodeBuffer0.position() + this.decodeBuffer1.position();
    }

    public void seek(int index) {
        int i;
        int seekPosition = index - this.decodeBufferDisplacement;
        if (seekPosition < 0) {
            LOG.error("", new Object[0]);
        }
        if ((i = this.decodeBuffer0.position() + this.decodeBuffer1.position() - seekPosition) > 0) {
            this.feedDecodeBuffer(i);
        }
        if (seekPosition <= this.decoded0) {
            this.decodeBuffer0.position(seekPosition);
        } else {
            this.decodeBuffer0.position(this.decoded0);
            this.decodeBuffer1.position(seekPosition - this.decoded0);
        }
        this.compactDecodeBuffer();
    }

    public int size() {
        return (int)Math.min(this.channelSize, Integer.MAX_VALUE);
    }

    public String getSourceName() {
        return this.channel.toString();
    }

    public String getText(@Nullable Interval interval) {
        Objects.requireNonNull(interval);
        int a = interval.a - this.decodeBufferDisplacement;
        int b = interval.b - this.decodeBufferDisplacement;
        int length = interval.length();
        char[] buffer = new char[length];
        if (b < this.decoded0) {
            CharBuffer intervalBuffer0 = this.decodeBuffer0.duplicate().position(a).limit(b + 1);
            intervalBuffer0.get(buffer);
        } else if (a >= this.decoded0) {
            CharBuffer intervalBuffer1 = this.decodeBuffer1.duplicate().position(a - this.decoded0).limit(b - this.decoded0 + 1);
            intervalBuffer1.get(buffer, 0, intervalBuffer1.remaining());
        } else {
            CharBuffer intervalBuffer0 = this.decodeBuffer0.duplicate().position(a).limit(this.decoded0);
            int length0 = intervalBuffer0.remaining();
            intervalBuffer0.get(buffer, 0, length0);
            CharBuffer intervalBuffer1 = this.decodeBuffer1.duplicate().position(0).limit(length - length0);
            intervalBuffer1.get(buffer, length0, intervalBuffer1.remaining());
        }
        return new String(buffer);
    }

    private void feedDecodeBuffer(int i) {
        int position1;
        int position0;
        int feed;
        if (i > 0 && (feed = (position0 = this.decodeBuffer0.position()) + (position1 = this.decodeBuffer1.position()) + i - (this.decoded0 + this.decoded1)) > 0) {
            try {
                CoderResult decodeResult;
                CoderResult coderResult = decodeResult = this.readBuffer.hasRemaining() ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
                do {
                    CharBuffer decodeBuffer;
                    if (decodeResult.isUnderflow() && this.decodedBytes < this.channelSize) {
                        this.feedReadBuffer();
                    }
                    int readBufferStart = this.readBuffer.position();
                    int capacity = this.decodeBuffer0.capacity();
                    if (this.decoded0 < capacity) {
                        int feeds0 = Math.min(feed, capacity - this.decoded0);
                        decodeBuffer = this.decodeBuffer0.duplicate();
                        decodeBuffer.position(this.decoded0);
                        decodeBuffer.limit(this.decoded0 + feeds0);
                        decodeResult = this.decoder.decode(this.readBuffer, decodeBuffer, this.channelEof);
                        int nextDecoded0 = decodeBuffer.position();
                        feed -= nextDecoded0 - this.decoded0;
                        this.decoded0 = nextDecoded0;
                    } else if (this.decoded1 < capacity) {
                        int feeds1 = Math.min(feed, capacity - this.decoded1);
                        decodeBuffer = this.decodeBuffer1.duplicate();
                        decodeBuffer.position(this.decoded1);
                        decodeBuffer.limit(this.decoded1 + feeds1);
                        decodeResult = this.decoder.decode(this.readBuffer, decodeBuffer, this.channelEof);
                        int nextDecoded1 = decodeBuffer.position();
                        feed -= nextDecoded1 - this.decoded1;
                        this.decoded1 = nextDecoded1;
                    } else {
                        Check.fail((String)"Insufficent LA buffer", (Object[])new Object[0]);
                    }
                    this.decodedBytes += (long)(this.readBuffer.position() - readBufferStart);
                } while (feed > 0 && (!this.channelEof || this.readBuffer.hasRemaining()));
            }
            catch (IOException e) {
                throw Exceptions.toRuntime((Throwable)e);
            }
        }
    }

    private void feedReadBuffer() throws IOException {
        if (this.readBuffer.hasRemaining()) {
            ByteBuffer remainingBuffer = this.readBuffer.duplicate();
            this.readBuffer.clear();
            this.readBuffer.put(remainingBuffer);
        } else {
            this.readBuffer.clear();
        }
        int read = 0;
        while (read >= 0 && this.readBuffer.hasRemaining()) {
            read = this.channel.read(this.readBuffer);
            if (read >= 0) continue;
            this.channelEof = true;
        }
        this.readBuffer.flip();
    }

    private void compactDecodeBuffer() {
        if (!this.decodeBuffer0.hasRemaining() && !this.decodeBuffer1.hasRemaining()) {
            this.decodeBufferDisplacement += this.decoded0;
            CharBuffer nextDecodeBuffer1 = this.decodeBuffer0.clear();
            this.decodeBuffer0 = this.decodeBuffer1;
            this.decoded0 = this.decoded1;
            this.decodeBuffer1 = nextDecodeBuffer1;
            this.decoded1 = 0;
            if (0 <= this.markIndex && this.markIndex < this.decodeBufferDisplacement) {
                LOG.warning("Mark buffer exceeded: {0}", new Object[]{this.decodeBufferDisplacement - this.markIndex});
            }
        }
    }
}

