/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.spi;

import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;

public abstract class FileScannerResultRenderHandlerFactory {
    public static SortedMap<HandlerId, FileScannerResultRenderHandler> getHandlers() {
        TreeMap<HandlerId, FileScannerResultRenderHandler> handlers = new TreeMap<HandlerId, FileScannerResultRenderHandler>();
        ServiceLoader<FileScannerResultRenderHandlerFactory> handlerFactories = ServiceLoader.load(FileScannerResultRenderHandlerFactory.class);
        for (FileScannerResultRenderHandlerFactory handlerFactory : handlerFactories) {
            handlerFactory.addHandlers(handlers);
        }
        return handlers;
    }

    protected final void addHandler(SortedMap<HandlerId, FileScannerResultRenderHandler> handlers, HandlerGroup group, String name, FileScannerResultRenderHandler handler) {
        this.addHandler(handlers, group, name, name, handler);
    }

    protected final void addHandler(SortedMap<HandlerId, FileScannerResultRenderHandler> handlers, HandlerGroup group, String name, String displayName, FileScannerResultRenderHandler handler) {
        handlers.put(new HandlerId(group, name, displayName), handler);
    }

    protected abstract void addHandlers(SortedMap<HandlerId, FileScannerResultRenderHandler> var1);

    public static final class HandlerId
    implements Comparable<HandlerId> {
        private final HandlerGroup group;
        private final String name;
        private final String displayName;

        HandlerId(HandlerGroup group, String name, String displayName) {
            this.group = group;
            this.name = name;
            this.displayName = displayName;
        }

        public HandlerGroup group() {
            return this.group;
        }

        public String name() {
            return this.name;
        }

        public String displayName() {
            return this.displayName;
        }

        @Override
        public int compareTo(HandlerId o) {
            int comparision = this.group.compareTo(o.group);
            if (comparision == 0) {
                comparision = this.name.compareTo(o.name);
            }
            return comparision;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.group, this.name});
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof HandlerId && (this == obj || this.compareTo((HandlerId)obj) == 0);
        }

        public String toString() {
            return this.group + ":" + this.name;
        }
    }

    public static enum HandlerGroup {
        TEXT("Text"),
        MISC("Misc");

        private final String displayName;

        private HandlerGroup(String displayName) {
            this.displayName = displayName;
        }

        public String displayName() {
            return this.displayName;
        }
    }
}

