/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.input.InputDecoder;
import de.carne.nio.compression.CompressionInfos;
import de.carne.nio.compression.CompressionProperty;
import de.carne.nio.compression.spi.Decoder;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class InputDecoders {
    public static final InputDecoder IDENTITY = new NoInputDecoder("stored");
    public static final InputDecoder ZERO = new NoInputDecoder("sparse");

    private InputDecoders() {
    }

    public static boolean isIdentity(InputDecoder inputDecoder) {
        return IDENTITY.equals(inputDecoder);
    }

    public static boolean isZero(InputDecoder inputDecoder) {
        return ZERO.equals(inputDecoder);
    }

    public static boolean isIdentityOrZero(InputDecoder inputDecoder) {
        return IDENTITY.equals(inputDecoder) || ZERO.equals(inputDecoder);
    }

    public static InputDecoder unsupportedInputDecoder(String name) {
        return new NoInputDecoder(name);
    }

    private static class NoInputDecoder
    extends InputDecoder {
        NoInputDecoder(String name) {
            super(name);
        }

        @Override
        public Decoder newDecoder() throws IOException {
            throw new IOException("Invaid or unsupported encoding format: " + this.name());
        }

        @Override
        public CompressionInfos decoderProperties() {
            return new CompressionInfos(){

                public Iterator<CompressionProperty> iterator() {
                    return Collections.emptyIterator();
                }

                public Object getProperty(CompressionProperty property) {
                    throw new NoSuchElementException();
                }

                public byte getByteProperty(CompressionProperty property) {
                    throw new NoSuchElementException();
                }

                public int getIntProperty(CompressionProperty property) {
                    throw new NoSuchElementException();
                }

                public long getLongProperty(CompressionProperty property) {
                    throw new NoSuchElementException();
                }

                public boolean getBooleanProperty(CompressionProperty property) {
                    throw new NoSuchElementException();
                }

                public Enum<?> getEnumProperty(CompressionProperty property) {
                    throw new NoSuchElementException();
                }
            };
        }
    }
}

