/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.input.InputDecoder;
import de.carne.filescanner.engine.input.InputDecoders;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.filescanner.engine.util.HexFormat;
import de.carne.util.Check;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jdt.annotation.NonNull;

public class InputDecoderTable
implements Iterable<Entry> {
    private final LinkedList<Entry> entries = new LinkedList();

    public static InputDecoderTable build(InputDecoder inputDecoder) {
        return new InputDecoderTable().add(inputDecoder);
    }

    public InputDecoderTable add(InputDecoder inputDecoder) {
        return this.add(inputDecoder, -1L, -1L, -1L);
    }

    public static InputDecoderTable build(InputDecoder inputDecoder, long offset, long encodedSize, long decodedSize) {
        return new InputDecoderTable().add(inputDecoder, offset, encodedSize, decodedSize);
    }

    public InputDecoderTable add(InputDecoder inputDecoder, long offset, long encodedSize, long decodedSize) {
        Check.assertTrue((!InputDecoders.IDENTITY.equals(inputDecoder) || encodedSize >= 0L ? 1 : 0) != 0);
        Check.assertTrue((!InputDecoders.ZERO.equals(inputDecoder) || decodedSize >= 0L ? 1 : 0) != 0);
        Entry entry = null;
        if (!this.entries.isEmpty()) {
            Entry lastEntry = this.entries.getLast();
            InputDecoder lastInputDecoder = lastEntry.inputDecoder();
            long lastOffset = lastEntry.offset();
            long lastEncodedSize = lastEntry.encodedSize();
            long lastDecodedSize = lastEntry.decodedSize();
            if ((offset < 0L || lastOffset >= 0L && lastEncodedSize >= 0L && lastOffset + lastEncodedSize == offset) && InputDecoders.isIdentityOrZero(lastInputDecoder) && lastInputDecoder.equals(inputDecoder)) {
                this.entries.removeLast();
                entry = new Entry(lastInputDecoder, lastOffset, encodedSize >= 0L ? lastEncodedSize + encodedSize : encodedSize, lastDecodedSize >= 0L && decodedSize >= 0L ? lastDecodedSize + decodedSize : -1L);
            }
        }
        this.entries.add(entry != null ? entry : new Entry(inputDecoder, offset, encodedSize, decodedSize));
        return this;
    }

    public int size() {
        return this.entries.size();
    }

    public void render(RenderOutput out) throws IOException {
        if (this.entries.size() == 1) {
            this.entries.get(0).inputDecoder().render(out);
        } else {
            int entryIndex = 0;
            for (Entry entry : this.entries) {
                StringBuilder entryComment = new StringBuilder();
                entryComment.append("// encoder mapping[").append(entryIndex).append("] offset:");
                long entryOffset = entry.offset();
                this.formatMappingValue(entryComment, entryOffset);
                long entryEncodedSize = entry.encodedSize();
                entryComment.append(" encoded:");
                this.formatMappingValue(entryComment, entryEncodedSize);
                long entryDecodedSize = entry.decodedSize();
                entryComment.append(" decoded:");
                this.formatMappingValue(entryComment, entryDecodedSize);
                out.setStyle(RenderStyle.COMMENT).writeln(entryComment.toString());
                entry.inputDecoder().render(out);
                ++entryIndex;
            }
        }
    }

    private StringBuilder formatMappingValue(StringBuilder buffer, long value) {
        if (value >= 0L) {
            HexFormat.formatLong(buffer, value);
        } else {
            buffer.append('*');
        }
        return buffer;
    }

    @Override
    public Iterator<@NonNull Entry> iterator() {
        return this.entries.iterator();
    }

    public class Entry {
        private final InputDecoder inputDecoder;
        private final long offset;
        private final long encodedSize;
        private final long decodedSize;

        Entry(InputDecoder inputDecoder, long offset, long encodedSize, long decodedSize) {
            this.inputDecoder = inputDecoder;
            this.offset = offset;
            this.encodedSize = encodedSize;
            this.decodedSize = decodedSize;
        }

        public InputDecoder inputDecoder() {
            return this.inputDecoder;
        }

        public long offset() {
            return this.offset;
        }

        public long encodedSize() {
            return this.encodedSize;
        }

        public long decodedSize() {
            return this.decodedSize;
        }
    }
}

