/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.nio.compression.CompressionInfos;
import de.carne.nio.compression.CompressionProperty;
import de.carne.nio.compression.spi.Decoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public abstract class InputDecoder {
    private final String name;

    protected InputDecoder(String name) {
        this.name = name;
    }

    public final String name() {
        return this.name;
    }

    public abstract Decoder newDecoder() throws IOException;

    public abstract CompressionInfos decoderProperties();

    public void render(RenderOutput out) throws IOException {
        out.setStyle(RenderStyle.NORMAL).write("encoding");
        out.setStyle(RenderStyle.OPERATOR).write(" = ");
        out.setStyle(RenderStyle.VALUE).writeln("'" + this.name + "'");
        CompressionInfos decoderProperties = this.decoderProperties();
        ArrayList sortedDecoderProperties = new ArrayList();
        this.decoderProperties().forEach(sortedDecoderProperties::add);
        Collections.sort(sortedDecoderProperties);
        for (CompressionProperty decoderProperty : decoderProperties) {
            out.setStyle(RenderStyle.NORMAL).write("decoderProperty[" + decoderProperty.key() + "]");
            out.setStyle(RenderStyle.OPERATOR).write(" = ");
            out.setStyle(RenderStyle.VALUE).writeln(decoderProperties.getProperty(decoderProperty).toString());
        }
    }
}

