/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.filescanner.engine.util.HexFormat;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FileScannerInputRange
extends FileScannerInput {
    private final FileScannerInput input;
    private final long base;
    private final long start;
    private final long end;

    FileScannerInputRange(String name, FileScannerInput input, long base, long start, long end) {
        super(name);
        this.input = input;
        this.base = base;
        this.start = start;
        this.end = end;
    }

    public FileScannerInput input() {
        return this.input;
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    @Override
    public long size() {
        return this.end - this.base;
    }

    @Override
    public int read(ByteBuffer buffer, long position) throws IOException {
        int read;
        long rebasedPosition = this.base + position;
        if (rebasedPosition + (long)buffer.remaining() <= this.end) {
            read = this.input.read(buffer, rebasedPosition);
        } else if (rebasedPosition < this.end) {
            ByteBuffer limitedBuffer = buffer.duplicate();
            limitedBuffer.limit((int)(this.end - rebasedPosition));
            read = this.input.read(limitedBuffer, rebasedPosition);
            buffer.position(limitedBuffer.position());
        } else {
            read = -1;
        }
        return read;
    }

    @Override
    public FileScannerInputRange range(long rangeStart, long rangeEnd) throws IOException {
        return this.base == 0L && this.start == rangeStart && this.end == rangeEnd ? this : super.range(rangeStart, rangeEnd);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append('[');
        HexFormat.formatLong(buffer, this.start);
        buffer.append('-');
        HexFormat.formatLong(buffer, this.end);
        buffer.append(']');
        return buffer.toString();
    }
}

