/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.util.Check;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

class FileScannerInputByteChannel
implements SeekableByteChannel {
    private final FileScannerInput input;
    private final long start;
    private final long end;
    private long position;

    FileScannerInputByteChannel(FileScannerInput input, long start, long end) {
        this.input = input;
        this.start = start;
        this.end = end;
        this.position = this.start;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized int read(@Nullable ByteBuffer dst) throws IOException {
        int read;
        Objects.requireNonNull(dst);
        if (this.position + (long)dst.remaining() <= this.end) {
            read = this.input.read(dst, this.position);
        } else if (this.position < this.end) {
            ByteBuffer limitedDst = dst.duplicate();
            limitedDst.limit((int)(this.end - this.position));
            read = this.input.read(limitedDst, this.position);
            dst.position(limitedDst.position());
        } else {
            read = -1;
        }
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public int write(@Nullable ByteBuffer src) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public long position() throws IOException {
        return this.position - this.start;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        Check.isTrue((newPosition >= 0L ? 1 : 0) != 0);
        this.position = newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.end - this.start;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new NonWritableChannelException();
    }
}

