/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.format.FlagRenderer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.Nullable;

public class WordFlagRenderer
extends FlagRenderer<Short> {
    private static final long serialVersionUID = -1868333347932279815L;
    private static final short MSB = Short.MIN_VALUE;

    @Override
    public @Nullable String put(short flag, String symbol) {
        return this.put(Short.valueOf(flag), symbol);
    }

    @Override
    protected Iterator<Short> flags() {
        return new Iterator<Short>(){
            private short nextFlag = Short.MIN_VALUE;

            @Override
            public boolean hasNext() {
                return this.nextFlag != 0;
            }

            @Override
            public Short next() {
                if (this.nextFlag == 0) {
                    throw new NoSuchElementException();
                }
                short flag = this.nextFlag;
                this.nextFlag = WordFlagRenderer.shift(this.nextFlag);
                return flag;
            }
        };
    }

    @Override
    protected boolean testFlag(Short value, Short flag) {
        short flagValue = flag;
        return (value & flagValue) != 0;
    }

    @Override
    protected Short combineFlags(Short flag1, Short flag2) {
        return (short)((flag1 | flag2) & 0xFFFF);
    }

    @Override
    protected String formatFlag(Short value, Short flag) {
        StringBuilder buffer = new StringBuilder();
        short valueValue = value;
        short flagValue = flag;
        short mask = Short.MIN_VALUE;
        while (mask != 0) {
            if ((flagValue & mask) != mask) {
                buffer.append('.');
            } else if ((flagValue & valueValue) != 0) {
                buffer.append('1');
            } else {
                buffer.append('0');
            }
            mask = WordFlagRenderer.shift(mask);
        }
        return buffer.toString();
    }

    static short shift(short flag) {
        return (short)((flag & 0xFFFF) >>> 1);
    }
}

