/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultContextValueSpec;
import de.carne.filescanner.engine.FileScannerResultDecodeContext;
import de.carne.filescanner.engine.FileScannerResultRenderContext;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.transfer.RenderOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class UnionSpec
extends CompositeSpec {
    private final FileScannerResultContextValueSpec<CompositeSpec> decodedSpec = new FileScannerResultContextValueSpec<CompositeSpec>(CompositeSpec.class, this.getClass().getSimpleName() + ".decodedSpec");
    private final List<CompositeSpec> elements = new ArrayList<CompositeSpec>();
    private boolean fixedSize = true;
    private int matchSize = 0;

    public <T extends CompositeSpec> T add(T element) {
        this.elements.add(element);
        this.fixedSize = this.fixedSize && element.isFixedSize();
        this.matchSize = Math.max(this.matchSize, element.matchSize());
        return element;
    }

    @Override
    public boolean isFixedSize() {
        return this.fixedSize;
    }

    @Override
    public int matchSize() {
        return this.matchSize;
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        boolean match = true;
        for (CompositeSpec element : this.elements) {
            ByteBuffer matchBuffer = buffer.duplicate();
            matchBuffer.order(element.byteOrder());
            match = element.matches(matchBuffer);
            if (!match) continue;
            break;
        }
        return match;
    }

    @Override
    public void decodeComposite(FileScannerResultDecodeContext context) throws IOException {
        for (CompositeSpec element : this.elements) {
            if (!context.matchComposite(element)) continue;
            element.decode(context);
            context.bindDecodedValue(this.decodedSpec, element);
            this.mergeDecodedExports(element);
            break;
        }
    }

    @Override
    public void renderComposite(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        if (this.hasRenderer()) {
            super.renderComposite(out, context);
        } else {
            this.decodedSpec.get().render(out, context);
        }
    }
}

