/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.FileScannerResultRenderContext;
import de.carne.filescanner.engine.StreamValue;
import de.carne.filescanner.engine.StreamValueDecoder;
import de.carne.filescanner.engine.ValueStreamer;
import de.carne.filescanner.engine.ValueStreamerFactory;
import de.carne.filescanner.engine.ValueStreamerStatus;
import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.filescanner.engine.util.SizeRenderer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;

public class ScanAttributeSpec
extends AttributeSpec<StreamValue> {
    private final ValueStreamerFactory valueStreamerFactory;
    private Supplier<? extends Number> limit = FinalSupplier.of(Integer.MAX_VALUE);
    private Supplier<? extends Number> step = FinalSupplier.of(1);

    public ScanAttributeSpec(Supplier<String> name, ValueStreamerFactory valueStreamerFactory) {
        super(StreamValue.class, Objects::equals, name);
        this.valueStreamerFactory = valueStreamerFactory;
        this.renderer(this::sizeRenderer);
    }

    public ScanAttributeSpec(String name, ValueStreamerFactory valueStreamerFactory) {
        this(FinalSupplier.of(name), valueStreamerFactory);
    }

    public ScanAttributeSpec limit(Supplier<? extends Number> limitSupplier) {
        this.limit = limitSupplier;
        return this;
    }

    public ScanAttributeSpec limit(int limitValue) {
        return this.limit(FinalSupplier.of(limitValue));
    }

    public ScanAttributeSpec step(Supplier<? extends Number> stepSupplier) {
        this.step = stepSupplier;
        return this;
    }

    public ScanAttributeSpec step(int stepValue) {
        return this.step(FinalSupplier.of(stepValue));
    }

    @Override
    public boolean isFixedSize() {
        return FormatSpecs.isFixedSize(this.limit);
    }

    @Override
    public int matchSize() {
        return this.isFixedSize() ? this.limit.get().intValue() : 0;
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        boolean match = false;
        if (this.isFixedSize()) {
            ValueStreamer streamer = this.valueStreamerFactory.getInstance();
            ValueStreamerStatus status = ValueStreamerStatus.STREAMING;
            while (status == ValueStreamerStatus.STREAMING && buffer.hasRemaining()) {
                status = streamer.stream(buffer);
            }
            match = status == ValueStreamerStatus.COMPLETE;
        } else {
            match = true;
        }
        return match;
    }

    @Override
    protected StreamValue decodeValue(FileScannerResultInputContext context) throws IOException {
        ValueStreamer streamer = this.valueStreamerFactory.getInstance();
        long length = context.readValue(this.step.get().intValue(), ScanAttributeSpec.decoder(streamer));
        return context.streamValue(length, false);
    }

    @Override
    protected StreamValue redecodeValue(@NonNull FileScannerResultRenderContext context) throws IOException {
        return context.streamValue(context.result().size(), true);
    }

    private static StreamValueDecoder<Long> decoder(final ValueStreamer streamer) {
        return new StreamValueDecoder<Long>(){
            private long length = 0L;

            @Override
            public ValueStreamerStatus stream(ByteBuffer buffer) {
                int decodeStart = buffer.position();
                ValueStreamerStatus status = streamer.stream(buffer);
                this.length += (long)(buffer.position() - decodeStart);
                return status;
            }

            @Override
            public Long decode() throws IOException {
                return this.length;
            }
        };
    }

    private void sizeRenderer(RenderOutput out, StreamValue value) throws IOException {
        SizeRenderer.LONG_RENDERER.render(out, value.size());
    }
}

