/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.util.FinalSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

public abstract class NumberAttributeSpec<T extends Number>
extends AttributeSpec<T> {
    protected NumberAttributeSpec(Class<T> type, Supplier<String> name) {
        super(type, Object::equals, name);
    }

    protected NumberAttributeSpec(Class<T> type, String name) {
        this(type, FinalSupplier.of(name));
    }

    @Override
    public final boolean isFixedSize() {
        return true;
    }

    @Override
    public final int matchSize() {
        return this.size();
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        return this.size() <= buffer.remaining() && this.validateValue(this.decodeValue(buffer));
    }

    @Override
    protected T decodeValue(FileScannerResultInputContext context) throws IOException {
        return (T)context.readValue(this.size(), this::decodeValue);
    }

    protected abstract int size();

    protected abstract T decodeValue(ByteBuffer var1);
}

