/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.EmptySpec;
import de.carne.filescanner.engine.format.FormatSpec;
import de.carne.filescanner.engine.util.FinalSupplier;
import java.nio.ByteBuffer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class FormatSpecs {
    public static final long MAX_MATCH_SIZE = 0x100000L;
    public static final CompositeSpec EMPTY = new EmptySpec();

    private FormatSpecs() {
    }

    public static boolean isResult(FormatSpec spec) {
        return spec instanceof CompositeSpec && ((CompositeSpec)spec).isResult();
    }

    public static boolean isFixedSize(Supplier<? extends Number> size) {
        return size instanceof FinalSupplier && FormatSpecs.isValidSize(size.get().longValue());
    }

    public static int matchSize(Supplier<? extends Number> size) {
        Number sizeValue;
        int matchSize = 0;
        if (size instanceof FinalSupplier && FormatSpecs.isValidSize((sizeValue = size.get()).longValue())) {
            matchSize = sizeValue.intValue();
        }
        return matchSize;
    }

    public static boolean matches(ByteBuffer buffer, Supplier<? extends Number> size) {
        return FormatSpecs.matches(buffer, size, (ByteBuffer b, Integer s) -> {
            b.position(b.position() + s);
            return true;
        });
    }

    public static boolean matches(ByteBuffer buffer, Supplier<? extends Number> size, Predicate<ByteBuffer> matcher) {
        return FormatSpecs.matches(buffer, size, (ByteBuffer b, Integer s) -> matcher.test((ByteBuffer)b));
    }

    public static boolean matches(ByteBuffer buffer, Supplier<? extends Number> size, BiPredicate<ByteBuffer, Integer> matcher) {
        boolean match = true;
        if (size instanceof FinalSupplier) {
            int matchSize;
            match = false;
            Number sizeValue = size.get();
            if (FormatSpecs.isValidSize(sizeValue.longValue()) && (matchSize = sizeValue.intValue()) <= buffer.remaining()) {
                match = matcher.test(buffer, matchSize);
            }
        }
        return match;
    }

    private static boolean isValidSize(long value) {
        return 0L <= value && value <= 0x100000L;
    }
}

