/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultContextValueSpecs;
import de.carne.filescanner.engine.StreamValue;
import de.carne.filescanner.engine.ValueStreamerFactory;
import de.carne.filescanner.engine.format.ArraySpec;
import de.carne.filescanner.engine.format.AttributeFormatter;
import de.carne.filescanner.engine.format.AttributeLinkResolver;
import de.carne.filescanner.engine.format.AttributeRenderer;
import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.format.AttributeValidator;
import de.carne.filescanner.engine.format.ByteArraySpec;
import de.carne.filescanner.engine.format.ByteAttributeLinkResolver;
import de.carne.filescanner.engine.format.ByteFlagRenderer;
import de.carne.filescanner.engine.format.ByteSpec;
import de.carne.filescanner.engine.format.ByteSymbolRenderer;
import de.carne.filescanner.engine.format.CharArraySpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.ConditionalCompositeSpec;
import de.carne.filescanner.engine.format.ConditionalSpec;
import de.carne.filescanner.engine.format.DWordArraySpec;
import de.carne.filescanner.engine.format.DWordAttributeLinkResolver;
import de.carne.filescanner.engine.format.DWordFlagRenderer;
import de.carne.filescanner.engine.format.DWordSpec;
import de.carne.filescanner.engine.format.DWordSymbolRenderer;
import de.carne.filescanner.engine.format.DecodeAtSpec;
import de.carne.filescanner.engine.format.EncodedInputSpec;
import de.carne.filescanner.engine.format.EncodedInputSpecConfig;
import de.carne.filescanner.engine.format.FormatSpec;
import de.carne.filescanner.engine.format.NumberAttributeSpec;
import de.carne.filescanner.engine.format.QWordArraySpec;
import de.carne.filescanner.engine.format.QWordAttributeLinkResolver;
import de.carne.filescanner.engine.format.QWordFlagRenderer;
import de.carne.filescanner.engine.format.QWordSpec;
import de.carne.filescanner.engine.format.QWordSymbolRenderer;
import de.carne.filescanner.engine.format.RangeAttributeSpec;
import de.carne.filescanner.engine.format.ScanAttributeSpec;
import de.carne.filescanner.engine.format.SequenceSpec;
import de.carne.filescanner.engine.format.StringAttributeSpec;
import de.carne.filescanner.engine.format.StringSpec;
import de.carne.filescanner.engine.format.StructSpec;
import de.carne.filescanner.engine.format.UnionSpec;
import de.carne.filescanner.engine.format.WordArraySpec;
import de.carne.filescanner.engine.format.WordAttributeLinkResolver;
import de.carne.filescanner.engine.format.WordFlagRenderer;
import de.carne.filescanner.engine.format.WordSpec;
import de.carne.filescanner.engine.format.WordSymbolRenderer;
import de.carne.filescanner.engine.format.grammar.FormatSpecGrammarBaseVisitor;
import de.carne.filescanner.engine.format.grammar.FormatSpecGrammarLexer;
import de.carne.filescanner.engine.format.grammar.FormatSpecGrammarParser;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.handler.SimpleRenderHandler;
import de.carne.filescanner.engine.util.AppleDateRenderer;
import de.carne.filescanner.engine.util.ByteHelper;
import de.carne.filescanner.engine.util.DosDateRenderer;
import de.carne.filescanner.engine.util.DosTimeRenderer;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.filescanner.engine.util.HexFormat;
import de.carne.filescanner.engine.util.IntHelper;
import de.carne.filescanner.engine.util.LongHelper;
import de.carne.filescanner.engine.util.PrettyFormat;
import de.carne.filescanner.engine.util.ShortHelper;
import de.carne.filescanner.engine.util.SizeRenderer;
import de.carne.filescanner.engine.util.StringHelper;
import de.carne.util.Exceptions;
import de.carne.util.Lazy;
import de.carne.util.Strings;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.eclipse.jdt.annotation.Nullable;

public abstract class FormatSpecDefinition {
    private static final Log LOG = new Log();
    private static final String LOG_LOADED_SPEC = "Loaded spec: {0}";
    private static final String LOG_ASSIGNED_SPEC = "Assigned spec {0}: {1}";
    private final Map<String, Set<Byte>> byteSymbolsMap = new HashMap<String, Set<Byte>>();
    private final Map<String, Set<Short>> wordSymbolsMap = new HashMap<String, Set<Short>>();
    private final Map<String, Set<Integer>> dwordSymbolsMap = new HashMap<String, Set<Integer>>();
    private final Map<String, Set<Long>> qwordSymbolsMap = new HashMap<String, Set<Long>>();
    private final Map<String, AttributeFormatter<Byte>> byteAttributeFormatter = new HashMap<String, AttributeFormatter<Byte>>();
    private final Map<String, AttributeFormatter<Short>> wordAttributeFormatter = new HashMap<String, AttributeFormatter<Short>>();
    private final Map<String, AttributeFormatter<Integer>> dwordAttributeFormatter = new HashMap<String, AttributeFormatter<Integer>>();
    private final Map<String, AttributeFormatter<Long>> qwordAttributeFormatter = new HashMap<String, AttributeFormatter<Long>>();
    private final Map<String, AttributeFormatter<byte[]>> byteArrayAttributeFormatter = new HashMap<String, AttributeFormatter<byte[]>>();
    private final Map<String, AttributeFormatter<short[]>> wordArrayAttributeFormatter = new HashMap<String, AttributeFormatter<short[]>>();
    private final Map<String, AttributeFormatter<int[]>> dwordArrayAttributeFormatter = new HashMap<String, AttributeFormatter<int[]>>();
    private final Map<String, AttributeFormatter<long[]>> qwordArrayAttributeFormatter = new HashMap<String, AttributeFormatter<long[]>>();
    private final Map<String, AttributeFormatter<String>> stringAttributeFormatter = new HashMap<String, AttributeFormatter<String>>();
    private final Map<String, AttributeRenderer<Byte>> byteAttributeRenderer = new HashMap<String, AttributeRenderer<Byte>>();
    private final Map<String, AttributeRenderer<Short>> wordAttributeRenderer = new HashMap<String, AttributeRenderer<Short>>();
    private final Map<String, AttributeRenderer<Integer>> dwordAttributeRenderer = new HashMap<String, AttributeRenderer<Integer>>();
    private final Map<String, AttributeRenderer<Long>> qwordAttributeRenderer = new HashMap<String, AttributeRenderer<Long>>();
    private final Map<String, AttributeRenderer<byte[]>> byteArrayAttributeRenderer = new HashMap<String, AttributeRenderer<byte[]>>();
    private final Map<String, AttributeRenderer<short[]>> wordArrayAttributeRenderer = new HashMap<String, AttributeRenderer<short[]>>();
    private final Map<String, AttributeRenderer<int[]>> dwordArrayAttributeRenderer = new HashMap<String, AttributeRenderer<int[]>>();
    private final Map<String, AttributeRenderer<long[]>> qwordArrayAttributeRenderer = new HashMap<String, AttributeRenderer<long[]>>();
    private final Map<String, AttributeRenderer<String>> stringAttributeRenderer = new HashMap<String, AttributeRenderer<String>>();
    private final Map<String, AttributeRenderer<StreamValue>> streamValueAttributeRenderer = new HashMap<String, AttributeRenderer<StreamValue>>();
    private final Map<String, Supplier<FormatSpec>> specs = new HashMap<String, Supplier<FormatSpec>>();
    private final List<Runnable> lateBindings = new LinkedList<Runnable>();
    private static final String UNKNOWN_EXTERNAL_REFERENCE = "Unknown reference #%s";
    private static final String INVALID_EXTERNAL_REFERENCE = "Invalid reference #%s (expected type: %s actual type: %s)";
    private static final String UNKNOWN_SPEC_REFERENCE = "Unknown reference @%s";
    private static final String INVALID_SPEC_REFERENCE = "Invalid reference @%s (expected type: %s actual type: %s)";

    protected FormatSpecDefinition() {
        this.byteAttributeFormatter.put("CharFormat", PrettyFormat.BYTE_CHAR_FORMATTER);
        this.byteAttributeFormatter.put(PrettyFormat.class.getSimpleName(), PrettyFormat.BYTE_FORMATTER);
        this.wordAttributeFormatter.put(PrettyFormat.class.getSimpleName(), PrettyFormat.SHORT_FORMATTER);
        this.dwordAttributeFormatter.put(PrettyFormat.class.getSimpleName(), PrettyFormat.INT_FORMATTER);
        this.qwordAttributeFormatter.put(PrettyFormat.class.getSimpleName(), PrettyFormat.LONG_FORMATTER);
        this.byteArrayAttributeFormatter.put(PrettyFormat.class.getSimpleName(), PrettyFormat.BYTE_ARRAY_FORMATTER);
        this.wordArrayAttributeFormatter.put(PrettyFormat.class.getSimpleName(), PrettyFormat.SHORT_ARRAY_FORMATTER);
        this.dwordArrayAttributeFormatter.put(PrettyFormat.class.getSimpleName(), PrettyFormat.INT_ARRAY_FORMATTER);
        this.qwordArrayAttributeFormatter.put(PrettyFormat.class.getSimpleName(), PrettyFormat.LONG_ARRAY_FORMATTER);
        this.stringAttributeFormatter.put(PrettyFormat.class.getSimpleName(), PrettyFormat.STRING_FORMATTER);
        this.byteAttributeFormatter.put(HexFormat.class.getSimpleName(), HexFormat.BYTE_FORMATTER);
        this.wordAttributeFormatter.put(HexFormat.class.getSimpleName(), HexFormat.SHORT_FORMATTER);
        this.dwordAttributeFormatter.put(HexFormat.class.getSimpleName(), HexFormat.INT_FORMATTER);
        this.qwordAttributeFormatter.put(HexFormat.class.getSimpleName(), HexFormat.LONG_FORMATTER);
        this.byteArrayAttributeFormatter.put(HexFormat.class.getSimpleName(), HexFormat.BYTE_ARRAY_FORMATTER);
        this.wordArrayAttributeFormatter.put(HexFormat.class.getSimpleName(), HexFormat.SHORT_ARRAY_FORMATTER);
        this.dwordArrayAttributeFormatter.put(HexFormat.class.getSimpleName(), HexFormat.INT_ARRAY_FORMATTER);
        this.qwordArrayAttributeFormatter.put(HexFormat.class.getSimpleName(), HexFormat.LONG_ARRAY_FORMATTER);
        this.byteAttributeRenderer.put(SizeRenderer.class.getSimpleName(), SizeRenderer.BYTE_RENDERER);
        this.wordAttributeRenderer.put(SizeRenderer.class.getSimpleName(), SizeRenderer.SHORT_RENDERER);
        this.dwordAttributeRenderer.put(SizeRenderer.class.getSimpleName(), SizeRenderer.INT_RENDERER);
        this.qwordAttributeRenderer.put(SizeRenderer.class.getSimpleName(), SizeRenderer.LONG_RENDERER);
        this.wordAttributeRenderer.put(DosTimeRenderer.class.getSimpleName(), DosTimeRenderer.RENDERER);
        this.wordAttributeRenderer.put(DosDateRenderer.class.getSimpleName(), DosDateRenderer.RENDERER);
        this.dwordAttributeRenderer.put(AppleDateRenderer.class.getSimpleName(), AppleDateRenderer.RENDERER);
    }

    public final String inputName() {
        return (String)FileScannerResultContextValueSpecs.INPUT_NAME.get();
    }

    public final Long inputSize() {
        return (Long)FileScannerResultContextValueSpecs.INPUT_SIZE.get();
    }

    public final Long formatPosition() {
        return (Long)FileScannerResultContextValueSpecs.FORMAT_POSITION.get();
    }

    public final Long resultPosition() {
        return (Long)FileScannerResultContextValueSpecs.RESULT_POSITION.get();
    }

    public final Integer sequenceElementIndex() {
        return (Integer)FileScannerResultContextValueSpecs.SEQUENCE_ELEMENT_INDEX.get();
    }

    public FileScannerResultRenderHandler simpleRenderer() {
        return SimpleRenderHandler.RENDER_HANDLER;
    }

    protected abstract URL getFormatSpecResource();

    public FormatSpecDefinition addByteAttributeFormatter(String identifier, AttributeFormatter<Byte> formatter) {
        if (this.byteAttributeFormatter.put(identifier, formatter) != null) {
            LOG.warning("Redefinition of byte attribute formatter ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addWordAttributeFormatter(String identifier, AttributeFormatter<Short> formatter) {
        if (this.wordAttributeFormatter.put(identifier, formatter) != null) {
            LOG.warning("Redefinition of word attribute formatter ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addDWordAttributeFormatter(String identifier, AttributeFormatter<Integer> formatter) {
        if (this.dwordAttributeFormatter.put(identifier, formatter) != null) {
            LOG.warning("Redefinition of dword attribute formatter ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addQWordAttributeFormatter(String identifier, AttributeFormatter<Long> formatter) {
        if (this.qwordAttributeFormatter.put(identifier, formatter) != null) {
            LOG.warning("Redefinition of qword attribute formatter ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addByteArrayAttributeFormatter(String identifier, AttributeFormatter<byte[]> formatter) {
        if (this.byteArrayAttributeFormatter.put(identifier, formatter) != null) {
            LOG.warning("Redefinition of byte array attribute formatter ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addWordArrayAttributeFormatter(String identifier, AttributeFormatter<short[]> formatter) {
        if (this.wordArrayAttributeFormatter.put(identifier, formatter) != null) {
            LOG.warning("Redefinition of word array attribute formatter ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addDWordArrayAttributeFormatter(String identifier, AttributeFormatter<int[]> formatter) {
        if (this.dwordArrayAttributeFormatter.put(identifier, formatter) != null) {
            LOG.warning("Redefinition of dword array attribute formatter ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addQWordArrayAttributeFormatter(String identifier, AttributeFormatter<long[]> formatter) {
        if (this.qwordArrayAttributeFormatter.put(identifier, formatter) != null) {
            LOG.warning("Redefinition of qword array attribute formatter ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addStringAttributeFormatter(String identifier, AttributeFormatter<String> formatter) {
        if (this.stringAttributeFormatter.put(identifier, formatter) != null) {
            LOG.warning("Redefinition of string attribute formatter ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addByteAttributeRenderer(String identifier, AttributeRenderer<Byte> renderer) {
        if (this.byteAttributeRenderer.put(identifier, renderer) != null) {
            LOG.warning("Redefinition of byte attribute renderer ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addWordAttributeRenderer(String identifier, AttributeRenderer<Short> renderer) {
        if (this.wordAttributeRenderer.put(identifier, renderer) != null) {
            LOG.warning("Redefinition of byte attribute renderer ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addDWordAttributeRenderer(String identifier, AttributeRenderer<Integer> renderer) {
        if (this.dwordAttributeRenderer.put(identifier, renderer) != null) {
            LOG.warning("Redefinition of dword attribute renderer ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addQWordAttributeRenderer(String identifier, AttributeRenderer<Long> renderer) {
        if (this.qwordAttributeRenderer.put(identifier, renderer) != null) {
            LOG.warning("Redefinition of qword attribute renderer ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addByteArrayAttributeRenderer(String identifier, AttributeRenderer<byte[]> renderer) {
        if (this.byteArrayAttributeRenderer.put(identifier, renderer) != null) {
            LOG.warning("Redefinition of byte array attribute renderer ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addWordArrayAttributeRenderer(String identifier, AttributeRenderer<short[]> renderer) {
        if (this.wordArrayAttributeRenderer.put(identifier, renderer) != null) {
            LOG.warning("Redefinition of byte array attribute renderer ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addDWordArrayAttributeRenderer(String identifier, AttributeRenderer<int[]> renderer) {
        if (this.dwordArrayAttributeRenderer.put(identifier, renderer) != null) {
            LOG.warning("Redefinition of dword array attribute renderer ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addQWordArrayAttributeRenderer(String identifier, AttributeRenderer<long[]> renderer) {
        if (this.qwordArrayAttributeRenderer.put(identifier, renderer) != null) {
            LOG.warning("Redefinition of qword array attribute renderer ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addStringAttributeRenderer(String identifier, AttributeRenderer<String> renderer) {
        if (this.stringAttributeRenderer.put(identifier, renderer) != null) {
            LOG.warning("Redefinition of string attribute renderer ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public FormatSpecDefinition addStreamValueAttributeRenderer(String identifier, AttributeRenderer<StreamValue> renderer) {
        if (this.streamValueAttributeRenderer.put(identifier, renderer) != null) {
            LOG.warning("Redefinition of stream value attribute renderer ''{0}''", new Object[]{identifier});
        }
        return this;
    }

    public void load() {
        URL formatSpecResourceUrl = this.getFormatSpecResource();
        try (InputStream resourceStream = formatSpecResourceUrl.openStream();){
            ErrorListener errorListener = new ErrorListener(formatSpecResourceUrl);
            CharStream input = CharStreams.fromStream((InputStream)resourceStream);
            FormatSpecGrammarLexer lexer = new FormatSpecGrammarLexer(input);
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)errorListener);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            FormatSpecGrammarParser parser = new FormatSpecGrammarParser((TokenStream)tokens);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
            Loader loader = new Loader(this::loadHelper);
            loader.visitFormatSpecs(parser.formatSpecs());
        }
        catch (IOException e) {
            throw Exceptions.toRuntime((Throwable)e);
        }
        for (Runnable lateBinding : this.lateBindings) {
            lateBinding.run();
        }
        this.lateBindings.clear();
        this.afterLoad();
    }

    protected void afterLoad() {
    }

    private FormatSpecDefinition loadHelper(FormatSpecGrammarParser.FormatSpecsContext ctx) {
        for (FormatSpecGrammarParser.SymbolsContext symbolsCtx : ctx.symbols()) {
            FormatSpecGrammarParser.QwordSymbolsContext qwordSymbolsCtx;
            FormatSpecGrammarParser.DwordSymbolsContext dwordSymbolsCtx;
            FormatSpecGrammarParser.WordSymbolsContext wordSymbolsCtx;
            FormatSpecGrammarParser.ByteSymbolsContext byteSymbolsCtx = symbolsCtx.byteSymbols();
            if (byteSymbolsCtx != null) {
                String byteSymbolsIdentifier = byteSymbolsCtx.symbolsIdentifier().getText();
                ByteSymbolRenderer byteSymbols = new ByteSymbolRenderer();
                this.loadSymbolDefinitions(byteSymbols, byteSymbolsCtx.symbolDefinition(), ByteHelper::decodeUnsigned);
                this.byteSymbolsMap.put(byteSymbolsIdentifier, byteSymbols.keySet());
                this.addByteAttributeRenderer(byteSymbolsIdentifier, byteSymbols);
            }
            if ((wordSymbolsCtx = symbolsCtx.wordSymbols()) != null) {
                String wordSymbolsIdentifier = wordSymbolsCtx.symbolsIdentifier().getText();
                WordSymbolRenderer wordSymbols = new WordSymbolRenderer();
                this.loadSymbolDefinitions(wordSymbols, wordSymbolsCtx.symbolDefinition(), ShortHelper::decodeUnsigned);
                this.wordSymbolsMap.put(wordSymbolsIdentifier, wordSymbols.keySet());
                this.addWordAttributeRenderer(wordSymbolsIdentifier, wordSymbols);
            }
            if ((dwordSymbolsCtx = symbolsCtx.dwordSymbols()) != null) {
                String dwordSymbolsIdentifier = dwordSymbolsCtx.symbolsIdentifier().getText();
                DWordSymbolRenderer dwordSymbols = new DWordSymbolRenderer();
                this.loadSymbolDefinitions(dwordSymbols, dwordSymbolsCtx.symbolDefinition(), IntHelper::decodeUnsigned);
                this.dwordSymbolsMap.put(dwordSymbolsIdentifier, dwordSymbols.keySet());
                this.addDWordAttributeRenderer(dwordSymbolsIdentifier, dwordSymbols);
            }
            if ((qwordSymbolsCtx = symbolsCtx.qwordSymbols()) == null) continue;
            String qwordSymbolsIdentifier = qwordSymbolsCtx.symbolsIdentifier().getText();
            QWordSymbolRenderer qwordSymbols = new QWordSymbolRenderer();
            this.loadSymbolDefinitions(qwordSymbols, qwordSymbolsCtx.symbolDefinition(), LongHelper::decodeUnsigned);
            this.qwordSymbolsMap.put(qwordSymbolsIdentifier, qwordSymbols.keySet());
            this.addQWordAttributeRenderer(qwordSymbolsIdentifier, qwordSymbols);
        }
        for (FormatSpecGrammarParser.FlagSymbolsContext flagSymbolsCtx : ctx.flagSymbols()) {
            FormatSpecGrammarParser.QwordFlagSymbolsContext qwordFlagSymbolsCtx;
            FormatSpecGrammarParser.DwordFlagSymbolsContext dwordFlagSymbolsCtx;
            FormatSpecGrammarParser.WordFlagSymbolsContext wordFlagSymbolsCtx;
            FormatSpecGrammarParser.ByteFlagSymbolsContext byteFlagSymbolsCtx = flagSymbolsCtx.byteFlagSymbols();
            if (byteFlagSymbolsCtx != null) {
                String byteFlagSymbolsIdentifier = byteFlagSymbolsCtx.symbolsIdentifier().getText();
                ByteFlagRenderer byteFlagSymbols = new ByteFlagRenderer();
                this.loadSymbolDefinitions(byteFlagSymbols, byteFlagSymbolsCtx.symbolDefinition(), ByteHelper::decodeUnsigned);
                this.addByteAttributeRenderer(byteFlagSymbolsIdentifier, byteFlagSymbols);
            }
            if ((wordFlagSymbolsCtx = flagSymbolsCtx.wordFlagSymbols()) != null) {
                String wordFlagSymbolsIdentifier = wordFlagSymbolsCtx.symbolsIdentifier().getText();
                WordFlagRenderer wordFlagSymbols = new WordFlagRenderer();
                this.loadSymbolDefinitions(wordFlagSymbols, wordFlagSymbolsCtx.symbolDefinition(), ShortHelper::decodeUnsigned);
                this.addWordAttributeRenderer(wordFlagSymbolsIdentifier, wordFlagSymbols);
            }
            if ((dwordFlagSymbolsCtx = flagSymbolsCtx.dwordFlagSymbols()) != null) {
                String dwordFlagSymbolsIdentifier = dwordFlagSymbolsCtx.symbolsIdentifier().getText();
                DWordFlagRenderer dwordFlagSymbols = new DWordFlagRenderer();
                this.loadSymbolDefinitions(dwordFlagSymbols, dwordFlagSymbolsCtx.symbolDefinition(), IntHelper::decodeUnsigned);
                this.addDWordAttributeRenderer(dwordFlagSymbolsIdentifier, dwordFlagSymbols);
            }
            if ((qwordFlagSymbolsCtx = flagSymbolsCtx.qwordFlagSymbols()) == null) continue;
            String qwordFlagSymbolsIdentifier = qwordFlagSymbolsCtx.symbolsIdentifier().getText();
            QWordFlagRenderer qwordFlagSymbols = new QWordFlagRenderer();
            this.loadSymbolDefinitions(qwordFlagSymbols, qwordFlagSymbolsCtx.symbolDefinition(), LongHelper::decodeUnsigned);
            this.addQWordAttributeRenderer(qwordFlagSymbolsIdentifier, qwordFlagSymbols);
        }
        for (FormatSpecGrammarParser.FormatSpecContext formatSpecCtx : ctx.formatSpec()) {
            this.loadFormatSpec(formatSpecCtx, ctx);
        }
        return this;
    }

    private <T extends Number> void loadSymbolDefinitions(Map<T, String> symbols, List<FormatSpecGrammarParser.SymbolDefinitionContext> symbolDefinitions, Function<String, T> parser) {
        for (FormatSpecGrammarParser.SymbolDefinitionContext symbolDefinitionCtx : symbolDefinitions) {
            String numberString = symbolDefinitionCtx.symbolValue().getText();
            Number number = (Number)parser.apply(numberString);
            String symbol = this.decodeQuotedString(symbolDefinitionCtx.symbol().getText());
            symbols.put(number, symbol);
        }
    }

    private void loadFormatSpec(FormatSpecGrammarParser.FormatSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        String specIdentifier = this.reserveSpecIdentifier(specCtx.specIdentifier());
        StructSpec spec = new StructSpec();
        for (FormatSpecGrammarParser.StructSpecElementContext elementCtx : specCtx.structSpecElement()) {
            spec.add(this.loadStructSpecElement(elementCtx, rootCtx));
        }
        this.applyResultModifier(spec, specCtx.textExpression());
        this.applyByteOrderModifier(spec, specCtx.compositeSpecByteOrderModifier());
        this.applyRendererModifier(spec, specCtx.compositeSpecRendererModifier());
        this.applyExportModifier(spec, specCtx.compositeSpecExportModifier());
        LOG.debug(LOG_ASSIGNED_SPEC, new Object[]{specIdentifier, spec});
        this.specs.put(specIdentifier, () -> spec);
    }

    private StructSpec loadStructSpec(FormatSpecGrammarParser.StructSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        String specIdentifier = this.reserveSpecIdentifier(specCtx.specIdentifier());
        StructSpec spec = this.loadAnonymousStructSpec(specCtx.anonymousStructSpec(), rootCtx);
        LOG.debug(LOG_ASSIGNED_SPEC, new Object[]{specIdentifier, spec});
        this.specs.put(specIdentifier, () -> spec);
        return spec;
    }

    private StructSpec loadAnonymousStructSpec(FormatSpecGrammarParser.AnonymousStructSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        StructSpec spec = new StructSpec();
        for (FormatSpecGrammarParser.StructSpecElementContext elementCtx : specCtx.structSpecElement()) {
            spec.add(this.loadStructSpecElement(elementCtx, rootCtx));
        }
        this.applyResultModifier(spec, specCtx.textExpression());
        this.applyByteOrderModifier(spec, specCtx.compositeSpecByteOrderModifier());
        this.applyRendererModifier(spec, specCtx.compositeSpecRendererModifier());
        this.applyExportModifier(spec, specCtx.compositeSpecExportModifier());
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private SequenceSpec loadSequenceSpec(FormatSpecGrammarParser.SequenceSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        String specIdentifier = this.reserveSpecIdentifier(specCtx.specIdentifier());
        SequenceSpec spec = this.loadAnonymousSequenceSpec(specCtx.anonymousSequenceSpec(), rootCtx);
        LOG.debug(LOG_ASSIGNED_SPEC, new Object[]{specIdentifier, spec});
        this.specs.put(specIdentifier, () -> spec);
        return spec;
    }

    private SequenceSpec loadAnonymousSequenceSpec(FormatSpecGrammarParser.AnonymousSequenceSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        FormatSpec elementSpec = this.loadStructSpecElement(specCtx.structSpecElement(), rootCtx);
        SequenceSpec spec = new SequenceSpec(elementSpec);
        this.applyStopBeforeModifier(spec, specCtx.sequenceSpecStopBeforeModifier(), rootCtx);
        this.applyStopAfterModifier(spec, specCtx.sequenceSpecStopAfterModifier(), rootCtx);
        this.applyMinModifier(spec, specCtx.sequenceSpecMinModifier());
        this.applyMaxModifier(spec, specCtx.sequenceSpecMaxModifier());
        this.applySizeModifier(spec, specCtx.sequenceSpecSizeModifier());
        this.applyResultModifier(spec, specCtx.textExpression());
        this.applyByteOrderModifier(spec, specCtx.compositeSpecByteOrderModifier());
        this.applyRendererModifier(spec, specCtx.compositeSpecRendererModifier());
        this.applyExportModifier(spec, specCtx.compositeSpecExportModifier());
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private void applyStopBeforeModifier(SequenceSpec spec, List<FormatSpecGrammarParser.SequenceSpecStopBeforeModifierContext> modifierCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        for (FormatSpecGrammarParser.SequenceSpecStopBeforeModifierContext stopBeforeCtx : modifierCtx) {
            spec.stopBefore(this.resolveSpec(rootCtx, stopBeforeCtx.specReference().referencedSpec().specIdentifier(), FormatSpec.class));
        }
    }

    private void applyStopAfterModifier(SequenceSpec spec, List<FormatSpecGrammarParser.SequenceSpecStopAfterModifierContext> modifierCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        for (FormatSpecGrammarParser.SequenceSpecStopAfterModifierContext stopAfterCtx : modifierCtx) {
            spec.stopAfter(this.resolveSpec(rootCtx, stopAfterCtx.specReference().referencedSpec().specIdentifier(), FormatSpec.class));
        }
    }

    private void applyMinModifier(SequenceSpec spec, List<FormatSpecGrammarParser.SequenceSpecMinModifierContext> modifierCtx) {
        for (FormatSpecGrammarParser.SequenceSpecMinModifierContext minCtx : modifierCtx) {
            spec.min(this.loadNumberExpression(minCtx.numberExpression()));
        }
    }

    private void applyMaxModifier(SequenceSpec spec, List<FormatSpecGrammarParser.SequenceSpecMaxModifierContext> modifierCtx) {
        for (FormatSpecGrammarParser.SequenceSpecMaxModifierContext maxCtx : modifierCtx) {
            spec.max(this.loadNumberExpression(maxCtx.numberExpression()));
        }
    }

    private void applySizeModifier(SequenceSpec spec, List<FormatSpecGrammarParser.SequenceSpecSizeModifierContext> modifierCtx) {
        for (FormatSpecGrammarParser.SequenceSpecSizeModifierContext sizeCtx : modifierCtx) {
            spec.size(this.loadNumberExpression(sizeCtx.numberExpression()));
        }
    }

    private ArraySpec loadArraySpec(FormatSpecGrammarParser.ArraySpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        String specIdentifier = this.reserveSpecIdentifier(specCtx.specIdentifier());
        ArraySpec spec = this.loadAnonymousArraySpec(specCtx.anonymousArraySpec(), rootCtx);
        LOG.debug(LOG_ASSIGNED_SPEC, new Object[]{specIdentifier, spec});
        this.specs.put(specIdentifier, () -> spec);
        return spec;
    }

    private ArraySpec loadAnonymousArraySpec(FormatSpecGrammarParser.AnonymousArraySpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        ArraySpec spec = new ArraySpec(this.loadNumberExpression(specCtx.numberExpression()));
        for (FormatSpecGrammarParser.AttributeSpecContext attributeSpecCtx : specCtx.attributeSpec()) {
            spec.add(this.loadAttributeSpec(attributeSpecCtx, rootCtx));
        }
        this.applyResultModifier(spec, specCtx.textExpression());
        this.applyByteOrderModifier(spec, specCtx.compositeSpecByteOrderModifier());
        this.applyRendererModifier(spec, specCtx.compositeSpecRendererModifier());
        this.applyExportModifier(spec, specCtx.compositeSpecExportModifier());
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private UnionSpec loadUnionSpec(FormatSpecGrammarParser.UnionSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        String specIdentifier = this.reserveSpecIdentifier(specCtx.specIdentifier());
        UnionSpec spec = this.loadAnonymousUnionSpec(specCtx.anonymousUnionSpec(), rootCtx);
        LOG.debug(LOG_ASSIGNED_SPEC, new Object[]{specIdentifier, spec});
        this.specs.put(specIdentifier, () -> spec);
        return spec;
    }

    private UnionSpec loadAnonymousUnionSpec(FormatSpecGrammarParser.AnonymousUnionSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        UnionSpec spec = new UnionSpec();
        for (FormatSpecGrammarParser.CompositeSpecExpressionContext expressionCtx : specCtx.compositeSpecExpression()) {
            spec.add(this.loadCompositeSpecExpression(expressionCtx, rootCtx));
        }
        this.applyResultModifier(spec, specCtx.textExpression());
        this.applyByteOrderModifier(spec, specCtx.compositeSpecByteOrderModifier());
        this.applyRendererModifier(spec, specCtx.compositeSpecRendererModifier());
        this.applyExportModifier(spec, specCtx.compositeSpecExportModifier());
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private void applyResultModifier(CompositeSpec spec, @Nullable FormatSpecGrammarParser.TextExpressionContext modiferCtx) {
        if (modiferCtx != null) {
            spec.result(this.loadTextExpression(modiferCtx));
        }
    }

    private void applyByteOrderModifier(CompositeSpec spec, List<FormatSpecGrammarParser.CompositeSpecByteOrderModifierContext> modifierCtx) {
        for (FormatSpecGrammarParser.CompositeSpecByteOrderModifierContext byteOrderCtx : modifierCtx) {
            if (byteOrderCtx.LittleEndian() != null) {
                spec.byteOrder(ByteOrder.LITTLE_ENDIAN);
                continue;
            }
            if (byteOrderCtx.BigEndian() != null) {
                spec.byteOrder(ByteOrder.BIG_ENDIAN);
                continue;
            }
            throw this.newLoadException(byteOrderCtx, "Unexpected byte order modifier", new Object[0]);
        }
    }

    private void applyRendererModifier(CompositeSpec spec, List<FormatSpecGrammarParser.CompositeSpecRendererModifierContext> modifierCtx) {
        for (FormatSpecGrammarParser.CompositeSpecRendererModifierContext rendererCtx : modifierCtx) {
            spec.renderer(this.resolveExternalReference(rendererCtx.externalReference(), FileScannerResultRenderHandler.class));
        }
    }

    private void applyExportModifier(CompositeSpec spec, List<FormatSpecGrammarParser.CompositeSpecExportModifierContext> modifierCtx) {
        for (FormatSpecGrammarParser.CompositeSpecExportModifierContext exportCtx : modifierCtx) {
            spec.export(this.resolveExternalReference(exportCtx.externalReference(), FileScannerResultExportHandler.class));
        }
    }

    private FormatSpec loadConditionalSpec(FormatSpecGrammarParser.ConditionalSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        for (FormatSpecGrammarParser.SpecReferenceContext specReferenceCtx : specCtx.specReference()) {
            this.resolveSpec(rootCtx, specReferenceCtx.referencedSpec().specIdentifier(), FormatSpec.class);
        }
        FormatSpecGrammarParser.ExternalReferenceContext externalReferenceCtx = specCtx.externalReference();
        Class<?> externalReferenceType = this.resolveExternalReferenceType(externalReferenceCtx);
        FormatSpec spec = CompositeSpec.class.isAssignableFrom(externalReferenceType) ? new ConditionalCompositeSpec(this.resolveExternalReference(specCtx.externalReference(), CompositeSpec.class)) : new ConditionalSpec(this.resolveExternalReference(specCtx.externalReference(), FormatSpec.class));
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private ConditionalCompositeSpec loadConditionalCompositeSpec(FormatSpecGrammarParser.ConditionalCompositeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        for (FormatSpecGrammarParser.SpecReferenceContext specReferenceCtx : specCtx.specReference()) {
            this.resolveSpec(rootCtx, specReferenceCtx.referencedSpec().specIdentifier(), CompositeSpec.class);
        }
        ConditionalCompositeSpec spec = new ConditionalCompositeSpec(this.resolveExternalReference(specCtx.externalReference(), CompositeSpec.class));
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private EncodedInputSpec loadEncodedInputSpec(FormatSpecGrammarParser.EncodedInputSpecContext specCtx) {
        EncodedInputSpec spec = new EncodedInputSpec(this.resolveExternalReference(specCtx.externalReference(), EncodedInputSpecConfig.class).get());
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private DecodeAtSpec loadDecodeAtSpec(FormatSpecGrammarParser.DecodeAtSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        DecodeAtSpec spec = new DecodeAtSpec(this.loadCompositeSpecExpression(specCtx.compositeSpecExpression(), rootCtx));
        spec.position(this.loadNumberExpression(specCtx.numberExpression()));
        FormatSpecGrammarParser.NumberValueContext levelCtx = specCtx.numberValue();
        if (levelCtx != null) {
            spec.level(this.decodeLongValue(levelCtx).intValue());
        }
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private AttributeSpec<?> loadAttributeSpec(FormatSpecGrammarParser.AttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        AttributeSpec spec;
        FormatSpecGrammarParser.ByteAttributeSpecContext byteAttributeSpecCtx = specCtx.byteAttributeSpec();
        if (byteAttributeSpecCtx != null) {
            spec = this.loadByteSpec(byteAttributeSpecCtx, rootCtx);
        } else {
            FormatSpecGrammarParser.WordAttributeSpecContext wordAttributeSpecCtx = specCtx.wordAttributeSpec();
            if (wordAttributeSpecCtx != null) {
                spec = this.loadWordSpec(wordAttributeSpecCtx, rootCtx);
            } else {
                FormatSpecGrammarParser.DwordAttributeSpecContext dwordAttributeSpecCtx = specCtx.dwordAttributeSpec();
                if (dwordAttributeSpecCtx != null) {
                    spec = this.loadDWordSpec(dwordAttributeSpecCtx, rootCtx);
                } else {
                    FormatSpecGrammarParser.QwordAttributeSpecContext qwordAttributeSpecCtx = specCtx.qwordAttributeSpec();
                    if (qwordAttributeSpecCtx != null) {
                        spec = this.loadQWordSpec(qwordAttributeSpecCtx, rootCtx);
                    } else {
                        FormatSpecGrammarParser.ByteArrayAttributeSpecContext byteArrayAttributeSpecCtx = specCtx.byteArrayAttributeSpec();
                        if (byteArrayAttributeSpecCtx != null) {
                            spec = this.loadByteArraySpec(byteArrayAttributeSpecCtx, rootCtx);
                        } else {
                            FormatSpecGrammarParser.WordArrayAttributeSpecContext wordArrayAttributeSpecCtx = specCtx.wordArrayAttributeSpec();
                            if (wordArrayAttributeSpecCtx != null) {
                                spec = this.loadWordArraySpec(wordArrayAttributeSpecCtx, rootCtx);
                            } else {
                                FormatSpecGrammarParser.DwordArrayAttributeSpecContext dwordArrayAttributeSpecCtx = specCtx.dwordArrayAttributeSpec();
                                if (dwordArrayAttributeSpecCtx != null) {
                                    spec = this.loadDWordArraySpec(dwordArrayAttributeSpecCtx, rootCtx);
                                } else {
                                    FormatSpecGrammarParser.QwordArrayAttributeSpecContext qwordArrayAttributeSpecCtx = specCtx.qwordArrayAttributeSpec();
                                    if (qwordArrayAttributeSpecCtx != null) {
                                        spec = this.loadQWordArraySpec(qwordArrayAttributeSpecCtx, rootCtx);
                                    } else {
                                        FormatSpecGrammarParser.CharArrayAttributeSpecContext charArrayAttributeSpecCtx = specCtx.charArrayAttributeSpec();
                                        if (charArrayAttributeSpecCtx != null) {
                                            spec = this.loadCharArraySpec(charArrayAttributeSpecCtx, rootCtx);
                                        } else {
                                            FormatSpecGrammarParser.StringAttributeSpecContext stringAttributeSpecCtx = specCtx.stringAttributeSpec();
                                            if (stringAttributeSpecCtx != null) {
                                                spec = this.loadStringSpec(stringAttributeSpecCtx, rootCtx);
                                            } else {
                                                FormatSpecGrammarParser.RangeAttributeSpecContext rangeAttributeSpecCtx = specCtx.rangeAttributeSpec();
                                                if (rangeAttributeSpecCtx != null) {
                                                    spec = this.loadRangeAttributeSpec(rangeAttributeSpecCtx, rootCtx);
                                                } else {
                                                    FormatSpecGrammarParser.ScanAttributeSpecContext scanAttributeSpecCtx = specCtx.scanAttributeSpec();
                                                    if (scanAttributeSpecCtx != null) {
                                                        spec = this.loadScanAttributeSpec(scanAttributeSpecCtx, rootCtx);
                                                    } else {
                                                        throw this.newLoadException(specCtx, "Unexpected attribute spec", new Object[0]);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return spec;
    }

    private ByteSpec loadByteSpec(FormatSpecGrammarParser.ByteAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        ByteSpec spec = new ByteSpec(this.loadTextExpression(specCtx.textExpression()));
        this.applyValidateNumberModifier(spec, specCtx.attributeValidateNumberModifier(), ByteHelper::decodeUnsigned, this.byteSymbolsMap);
        this.applyFormatModifier(spec, specCtx.attributeFormatModifier(), this.byteAttributeFormatter);
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.byteAttributeRenderer);
        this.applyLinkModifier(spec, specCtx.attributeLinkModifier(), ByteAttributeLinkResolver::new);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private WordSpec loadWordSpec(FormatSpecGrammarParser.WordAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        WordSpec spec = new WordSpec(this.loadTextExpression(specCtx.textExpression()));
        this.applyValidateNumberModifier(spec, specCtx.attributeValidateNumberModifier(), ShortHelper::decodeUnsigned, this.wordSymbolsMap);
        this.applyFormatModifier(spec, specCtx.attributeFormatModifier(), this.wordAttributeFormatter);
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.wordAttributeRenderer);
        this.applyLinkModifier(spec, specCtx.attributeLinkModifier(), WordAttributeLinkResolver::new);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private DWordSpec loadDWordSpec(FormatSpecGrammarParser.DwordAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        DWordSpec spec = new DWordSpec(this.loadTextExpression(specCtx.textExpression()));
        this.applyValidateNumberModifier(spec, specCtx.attributeValidateNumberModifier(), IntHelper::decodeUnsigned, this.dwordSymbolsMap);
        this.applyFormatModifier(spec, specCtx.attributeFormatModifier(), this.dwordAttributeFormatter);
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.dwordAttributeRenderer);
        this.applyLinkModifier(spec, specCtx.attributeLinkModifier(), DWordAttributeLinkResolver::new);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private QWordSpec loadQWordSpec(FormatSpecGrammarParser.QwordAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        QWordSpec spec = new QWordSpec(this.loadTextExpression(specCtx.textExpression()));
        this.applyValidateNumberModifier(spec, specCtx.attributeValidateNumberModifier(), LongHelper::decodeUnsigned, this.qwordSymbolsMap);
        this.applyFormatModifier(spec, specCtx.attributeFormatModifier(), this.qwordAttributeFormatter);
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.qwordAttributeRenderer);
        this.applyLinkModifier(spec, specCtx.attributeLinkModifier(), QWordAttributeLinkResolver::new);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private ByteArraySpec loadByteArraySpec(FormatSpecGrammarParser.ByteArrayAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        ByteArraySpec spec = new ByteArraySpec(this.loadTextExpression(specCtx.textExpression()));
        spec.length(this.loadNumberExpression(specCtx.numberExpression()));
        this.applyValidateNumberArrayModifier(spec, specCtx.attributeValidateNumberArrayModifier(), ByteHelper::decodeUnsignedArray);
        this.applyFormatModifier(spec, specCtx.attributeFormatModifier(), this.byteArrayAttributeFormatter);
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.byteArrayAttributeRenderer);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private WordArraySpec loadWordArraySpec(FormatSpecGrammarParser.WordArrayAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        WordArraySpec spec = new WordArraySpec(this.loadTextExpression(specCtx.textExpression()));
        spec.length(this.loadNumberExpression(specCtx.numberExpression()));
        this.applyValidateNumberArrayModifier(spec, specCtx.attributeValidateNumberArrayModifier(), ShortHelper::decodeUnsignedArray);
        this.applyFormatModifier(spec, specCtx.attributeFormatModifier(), this.wordArrayAttributeFormatter);
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.wordArrayAttributeRenderer);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private DWordArraySpec loadDWordArraySpec(FormatSpecGrammarParser.DwordArrayAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        DWordArraySpec spec = new DWordArraySpec(this.loadTextExpression(specCtx.textExpression()));
        spec.length(this.loadNumberExpression(specCtx.numberExpression()));
        this.applyValidateNumberArrayModifier(spec, specCtx.attributeValidateNumberArrayModifier(), IntHelper::decodeUnsignedArray);
        this.applyFormatModifier(spec, specCtx.attributeFormatModifier(), this.dwordArrayAttributeFormatter);
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.dwordArrayAttributeRenderer);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private QWordArraySpec loadQWordArraySpec(FormatSpecGrammarParser.QwordArrayAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        QWordArraySpec spec = new QWordArraySpec(this.loadTextExpression(specCtx.textExpression()));
        spec.length(this.loadNumberExpression(specCtx.numberExpression()));
        this.applyValidateNumberArrayModifier(spec, specCtx.attributeValidateNumberArrayModifier(), LongHelper::decodeUnsignedArray);
        this.applyFormatModifier(spec, specCtx.attributeFormatModifier(), this.qwordArrayAttributeFormatter);
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.qwordArrayAttributeRenderer);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private CharArraySpec loadCharArraySpec(FormatSpecGrammarParser.CharArrayAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        CharArraySpec spec = new CharArraySpec(this.loadTextExpression(specCtx.textExpression()));
        spec.size(this.loadNumberExpression(specCtx.numberExpression()));
        this.applyCharsetModifier(spec, specCtx.stringAttributeCharsetModifier());
        this.applyValidateStringModifier(spec, specCtx.attributeValidateStringModifier());
        this.applyFormatModifier(spec, specCtx.attributeFormatModifier(), this.stringAttributeFormatter);
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.stringAttributeRenderer);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private StringSpec loadStringSpec(FormatSpecGrammarParser.StringAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        StringSpec spec = new StringSpec(this.loadTextExpression(specCtx.textExpression()));
        this.applyCharsetModifier(spec, specCtx.stringAttributeCharsetModifier());
        this.applyValidateStringModifier(spec, specCtx.attributeValidateStringModifier());
        this.applyFormatModifier(spec, specCtx.attributeFormatModifier(), this.stringAttributeFormatter);
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.stringAttributeRenderer);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private RangeAttributeSpec loadRangeAttributeSpec(FormatSpecGrammarParser.RangeAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        RangeAttributeSpec spec = new RangeAttributeSpec(this.loadTextExpression(specCtx.textExpression()));
        FormatSpecGrammarParser.NumberExpressionContext sizeCtx = specCtx.numberExpression();
        if (sizeCtx != null) {
            spec.size(this.loadNumberExpression(specCtx.numberExpression()));
        }
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.streamValueAttributeRenderer);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private ScanAttributeSpec loadScanAttributeSpec(FormatSpecGrammarParser.ScanAttributeSpecContext specCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        ScanAttributeSpec spec = new ScanAttributeSpec(this.loadTextExpression(specCtx.textExpression()), this.resolveExternalReference(specCtx.externalReference(), ValueStreamerFactory.class).get());
        List<FormatSpecGrammarParser.NumberExpressionContext> numberArguments = specCtx.numberExpression();
        if (numberArguments != null) {
            Iterator<FormatSpecGrammarParser.NumberExpressionContext> numberArgumentsIterator = numberArguments.iterator();
            if (specCtx.Ellipsis() == null) {
                spec.limit(this.loadNumberExpression(numberArgumentsIterator.next()));
            }
            if (numberArgumentsIterator.hasNext()) {
                spec.step(this.loadNumberExpression(numberArgumentsIterator.next()));
            }
        }
        this.applyRendererModifier(spec, specCtx.attributeRendererModifier(), this.streamValueAttributeRenderer);
        this.bindAttributeSpecIfNeeded(spec, specCtx.specIdentifier(), specCtx.scopeIdentifier(), rootCtx);
        LOG.debug(LOG_LOADED_SPEC, new Object[]{spec});
        return spec;
    }

    private <T extends Number> void applyValidateNumberModifier(NumberAttributeSpec<T> spec, List<FormatSpecGrammarParser.AttributeValidateNumberModifierContext> modifierCtx, Function<String, T> decode, Map<String, Set<T>> symbolsMap) {
        for (FormatSpecGrammarParser.AttributeValidateNumberModifierContext validateCtx : modifierCtx) {
            FormatSpecGrammarParser.NumberValueSetContext numberValueSetCtx = validateCtx.numberValueSet();
            if (numberValueSetCtx != null) {
                spec.validate(this.decodeNumberValueSet(numberValueSetCtx, decode));
                continue;
            }
            FormatSpecGrammarParser.SpecReferenceContext specReferenceCtx = validateCtx.specReference();
            if (specReferenceCtx != null) {
                String specIdentifier = specReferenceCtx.referencedSpec().getText();
                Set<T> symbols = symbolsMap.get(specIdentifier);
                if (symbols == null) {
                    throw this.newLoadException(specReferenceCtx, "Unknown symbols reference @%s", specIdentifier);
                }
                spec.validate(symbols);
                continue;
            }
            throw this.newLoadException(validateCtx, "Unexpected validate number modifier", new Object[0]);
        }
    }

    private <T extends Number> Set<T> decodeNumberValueSet(FormatSpecGrammarParser.NumberValueSetContext numberValueSetCtx, Function<String, T> decode) {
        HashSet<Number> numberValueSet = new HashSet<Number>();
        for (FormatSpecGrammarParser.NumberValueContext numberValueCtx : numberValueSetCtx.numberValue()) {
            numberValueSet.add((Number)decode.apply(numberValueCtx.getText()));
        }
        return numberValueSet;
    }

    private <T> void applyValidateNumberArrayModifier(AttributeSpec<T> spec, List<FormatSpecGrammarParser.AttributeValidateNumberArrayModifierContext> modifierCtx, Function<String[], T> decode) {
        for (FormatSpecGrammarParser.AttributeValidateNumberArrayModifierContext validateCtx : modifierCtx) {
            FormatSpecGrammarParser.NumberArrayValueSetContext numberArrayValueSetCtx = validateCtx.numberArrayValueSet();
            if (numberArrayValueSetCtx != null) {
                spec.validate(this.decodeNumberArrayValueSet(numberArrayValueSetCtx, decode));
                continue;
            }
            throw this.newLoadException(validateCtx, "Unexpected validate number array modifier", new Object[0]);
        }
    }

    private <T> Set<T> decodeNumberArrayValueSet(FormatSpecGrammarParser.NumberArrayValueSetContext numberArrayValueSetCtx, Function<String[], T> decode) {
        HashSet<T> numberArrayValueSet = new HashSet<T>();
        for (FormatSpecGrammarParser.NumberArrayValueContext numberArrayValueCtx : numberArrayValueSetCtx.numberArrayValue()) {
            T numberArrayValue = this.decodeNumberArrayValue(numberArrayValueCtx.numberValue(), decode);
            numberArrayValueSet.add(numberArrayValue);
        }
        return numberArrayValueSet;
    }

    private <T> T decodeNumberArrayValue(List<FormatSpecGrammarParser.NumberValueContext> numberValueCtx, Function<String[], T> decode) {
        String[] numberArrayValueTexts = new String[numberValueCtx.size()];
        int numberArrayValueTextIndex = 0;
        for (FormatSpecGrammarParser.NumberValueContext numberValue : numberValueCtx) {
            numberArrayValueTexts[numberArrayValueTextIndex] = numberValue.getText();
            ++numberArrayValueTextIndex;
        }
        return decode.apply(numberArrayValueTexts);
    }

    private void applyValidateStringModifier(AttributeSpec<String> spec, List<FormatSpecGrammarParser.AttributeValidateStringModifierContext> modifierCtx) {
        for (FormatSpecGrammarParser.AttributeValidateStringModifierContext validateCtx : modifierCtx) {
            FormatSpecGrammarParser.ValidationTextSetContext validationTextSetCtx = validateCtx.validationTextSet();
            if (validationTextSetCtx != null) {
                HashSet<String> simpleTextSet = new HashSet<String>();
                HashSet<Pattern> patternSet = new HashSet<Pattern>();
                for (FormatSpecGrammarParser.ValidationTextContext validationTextCtx : validationTextSetCtx.validationText()) {
                    FormatSpecGrammarParser.RegexTextContext regexTextCtx = validationTextCtx.regexText();
                    if (regexTextCtx != null) {
                        patternSet.add(Pattern.compile(this.decodeReqexString(regexTextCtx.getText())));
                        continue;
                    }
                    FormatSpecGrammarParser.SimpleTextContext simpleTextCtx = validationTextCtx.simpleText();
                    if (simpleTextCtx != null) {
                        simpleTextSet.add(this.decodeQuotedString(simpleTextCtx.getText()));
                        continue;
                    }
                    throw this.newLoadException(validationTextCtx, "Unexpected validate string argument", new Object[0]);
                }
                if (patternSet.isEmpty()) {
                    spec.validate(simpleTextSet);
                    continue;
                }
                spec.validate((String)((Object)((AttributeValidator<String>)s -> {
                    boolean valid = simpleTextSet.contains(s);
                    if (!valid) {
                        for (Pattern pattern : patternSet) {
                            if (!pattern.matcher((CharSequence)s).matches()) continue;
                            valid = true;
                            break;
                        }
                    }
                    return valid;
                })));
                continue;
            }
            throw this.newLoadException(validateCtx, "Unexpected validate string modifier", new Object[0]);
        }
    }

    private <T> void applyFormatModifier(AttributeSpec<T> spec, List<FormatSpecGrammarParser.AttributeFormatModifierContext> modifierCtx, Map<String, AttributeFormatter<T>> formatters) {
        for (FormatSpecGrammarParser.AttributeFormatModifierContext formatCtx : modifierCtx) {
            FormatSpecGrammarParser.FormatTextContext formatTextCtx = formatCtx.formatText();
            if (formatTextCtx != null) {
                spec.format(this.decodeQuotedString(formatTextCtx.getText()));
                continue;
            }
            FormatSpecGrammarParser.SpecReferenceContext specReferenceCtx = formatCtx.specReference();
            if (specReferenceCtx != null) {
                String specIdentifier = specReferenceCtx.referencedSpec().getText();
                AttributeFormatter<T> formatter = formatters.get(specIdentifier);
                if (formatter == null) {
                    throw this.newLoadException(specReferenceCtx, "Unknown formatter reference @%s", specIdentifier);
                }
                spec.format(formatter);
                continue;
            }
            throw this.newLoadException(formatCtx, "Unexpected format modifier", new Object[0]);
        }
    }

    private <T> void applyRendererModifier(AttributeSpec<T> spec, List<FormatSpecGrammarParser.AttributeRendererModifierContext> modifierCtx, Map<String, AttributeRenderer<T>> formatters) {
        for (FormatSpecGrammarParser.AttributeRendererModifierContext formatCtx : modifierCtx) {
            FormatSpecGrammarParser.SpecReferenceContext specReferenceCtx = formatCtx.specReference();
            if (specReferenceCtx != null) {
                String specIdentifier = specReferenceCtx.referencedSpec().getText();
                AttributeRenderer<T> renderer = formatters.get(specIdentifier);
                if (renderer == null) {
                    throw this.newLoadException(specReferenceCtx, "Unknown renderer reference @%s", specIdentifier);
                }
                spec.renderer(renderer);
                continue;
            }
            throw this.newLoadException(formatCtx, "Unexpected renderer modifier", new Object[0]);
        }
    }

    private <T> void applyLinkModifier(AttributeSpec<T> spec, List<FormatSpecGrammarParser.AttributeLinkModifierContext> modifierCtx, Function<Supplier<? extends Number>, AttributeLinkResolver<T>> linkResolverFactory) {
        for (FormatSpecGrammarParser.AttributeLinkModifierContext linkCtx : modifierCtx) {
            FormatSpecGrammarParser.NumberExpressionContext linkBaseCtx = linkCtx.numberExpression();
            QWordSpec linkBase = linkBaseCtx != null ? this.loadNumberExpression(linkBaseCtx) : FileScannerResultContextValueSpecs.FORMAT_POSITION;
            spec.link(linkResolverFactory.apply(linkBase));
        }
    }

    private void applyCharsetModifier(StringAttributeSpec spec, List<FormatSpecGrammarParser.StringAttributeCharsetModifierContext> modifierCtx) {
        for (FormatSpecGrammarParser.StringAttributeCharsetModifierContext charsetCtx : modifierCtx) {
            FormatSpecGrammarParser.SimpleTextContext simpleTextCtx = charsetCtx.simpleText();
            if (simpleTextCtx != null) {
                String charsetName = this.decodeQuotedString(simpleTextCtx.getText());
                spec.charset(Charset.forName(charsetName));
                continue;
            }
            throw this.newLoadException(charsetCtx, "Unexpected charset modifier", new Object[0]);
        }
    }

    private void bindAttributeSpecIfNeeded(AttributeSpec<?> spec, @Nullable FormatSpecGrammarParser.SpecIdentifierContext specIdentifierCtx, @Nullable FormatSpecGrammarParser.ScopeIdentifierContext scopeIdentiferCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        if (specIdentifierCtx != null) {
            String specIdentifier = this.reserveSpecIdentifier(specIdentifierCtx);
            if (scopeIdentiferCtx != null) {
                this.lateBindings.add(() -> spec.bind(this.resolveSpec(rootCtx, scopeIdentiferCtx.specIdentifier(), CompositeSpec.class)));
            } else {
                spec.bind();
            }
            LOG.debug(LOG_ASSIGNED_SPEC, new Object[]{specIdentifier, spec});
            this.specs.put(specIdentifier, () -> spec);
        }
    }

    private FormatSpec loadStructSpecElement(FormatSpecGrammarParser.StructSpecElementContext elementCtx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        FormatSpec element;
        FormatSpecGrammarParser.SpecReferenceContext specReferenceCtx = elementCtx.specReference();
        if (specReferenceCtx != null) {
            element = this.resolveSpec(rootCtx, specReferenceCtx.referencedSpec().specIdentifier(), FormatSpec.class);
        } else {
            FormatSpecGrammarParser.AttributeSpecContext attributeSpecCtx = elementCtx.attributeSpec();
            if (attributeSpecCtx != null) {
                element = this.loadAttributeSpec(attributeSpecCtx, rootCtx);
            } else {
                FormatSpecGrammarParser.AnonymousStructSpecContext anonymousStructSpecCtx = elementCtx.anonymousStructSpec();
                if (anonymousStructSpecCtx != null) {
                    element = this.loadAnonymousStructSpec(anonymousStructSpecCtx, rootCtx);
                } else {
                    FormatSpecGrammarParser.AnonymousArraySpecContext anonymousArraySpecCtx = elementCtx.anonymousArraySpec();
                    if (anonymousArraySpecCtx != null) {
                        element = this.loadAnonymousArraySpec(anonymousArraySpecCtx, rootCtx);
                    } else {
                        FormatSpecGrammarParser.AnonymousSequenceSpecContext anonymousSequenceSpecCtx = elementCtx.anonymousSequenceSpec();
                        if (anonymousSequenceSpecCtx != null) {
                            element = this.loadAnonymousSequenceSpec(anonymousSequenceSpecCtx, rootCtx);
                        } else {
                            FormatSpecGrammarParser.AnonymousUnionSpecContext anonymousUnionSpecCtx = elementCtx.anonymousUnionSpec();
                            if (anonymousUnionSpecCtx != null) {
                                element = this.loadAnonymousUnionSpec(anonymousUnionSpecCtx, rootCtx);
                            } else {
                                FormatSpecGrammarParser.ConditionalSpecContext conditionalSpecCtx = elementCtx.conditionalSpec();
                                if (conditionalSpecCtx != null) {
                                    element = this.loadConditionalSpec(conditionalSpecCtx, rootCtx);
                                } else {
                                    FormatSpecGrammarParser.EncodedInputSpecContext encodedInputSpecCtx = elementCtx.encodedInputSpec();
                                    if (encodedInputSpecCtx != null) {
                                        element = this.loadEncodedInputSpec(encodedInputSpecCtx);
                                    } else {
                                        FormatSpecGrammarParser.DecodeAtSpecContext decodeAtSpecCtx = elementCtx.decodeAtSpec();
                                        if (decodeAtSpecCtx != null) {
                                            element = this.loadDecodeAtSpec(decodeAtSpecCtx, rootCtx);
                                        } else {
                                            throw this.newLoadException(elementCtx, "Unexpected format spec element", new Object[0]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return element;
    }

    private CompositeSpec loadCompositeSpecExpression(FormatSpecGrammarParser.CompositeSpecExpressionContext ctx, FormatSpecGrammarParser.FormatSpecsContext rootCtx) {
        CompositeSpec spec;
        FormatSpecGrammarParser.SpecReferenceContext specReferenceCtx = ctx.specReference();
        if (specReferenceCtx != null) {
            spec = this.resolveSpec(rootCtx, specReferenceCtx.referencedSpec().specIdentifier(), CompositeSpec.class);
        } else {
            FormatSpecGrammarParser.AnonymousStructSpecContext anonymousStructSpecCtx = ctx.anonymousStructSpec();
            if (anonymousStructSpecCtx != null) {
                spec = this.loadAnonymousStructSpec(anonymousStructSpecCtx, rootCtx);
            } else {
                FormatSpecGrammarParser.AnonymousUnionSpecContext anonymousUnionSpecCtx = ctx.anonymousUnionSpec();
                if (anonymousUnionSpecCtx != null) {
                    spec = this.loadAnonymousUnionSpec(anonymousUnionSpecCtx, rootCtx);
                } else {
                    FormatSpecGrammarParser.AnonymousSequenceSpecContext anonymousSequenceSpecCtx = ctx.anonymousSequenceSpec();
                    if (anonymousSequenceSpecCtx != null) {
                        spec = this.loadAnonymousSequenceSpec(anonymousSequenceSpecCtx, rootCtx);
                    } else {
                        FormatSpecGrammarParser.ConditionalCompositeSpecContext conditionalCompositeSpecCtx = ctx.conditionalCompositeSpec();
                        if (conditionalCompositeSpecCtx != null) {
                            spec = this.loadConditionalCompositeSpec(conditionalCompositeSpecCtx, rootCtx);
                        } else {
                            throw this.newLoadException(ctx, "Unexpected composite spec element", new Object[0]);
                        }
                    }
                }
            }
        }
        return spec;
    }

    private Supplier<? extends Number> loadNumberExpression(FormatSpecGrammarParser.NumberExpressionContext ctx) {
        Supplier<Number> numberExpression;
        FormatSpecGrammarParser.NumberValueContext numberValueCtx = ctx.numberValue();
        if (numberValueCtx != null) {
            numberExpression = FinalSupplier.of(Long.decode(numberValueCtx.getText()));
        } else {
            FormatSpecGrammarParser.SpecReferenceContext specReferenceCtx = ctx.specReference();
            if (specReferenceCtx != null) {
                numberExpression = this.resolveSpec(specReferenceCtx.referencedSpec().specIdentifier(), NumberAttributeSpec.class);
            } else {
                FormatSpecGrammarParser.ExternalReferenceContext externalReferenceCtx = ctx.externalReference();
                if (externalReferenceCtx != null) {
                    numberExpression = this.resolveExternalReference(externalReferenceCtx, Number.class);
                } else {
                    throw this.newLoadException(ctx, "Unexpected number expression", new Object[0]);
                }
            }
        }
        return numberExpression;
    }

    private Long decodeLongValue(FormatSpecGrammarParser.NumberValueContext ctx) {
        Long value;
        try {
            value = Long.decode(ctx.getText());
        }
        catch (NumberFormatException e) {
            throw this.newLoadException(e, ctx, "Unexpected number value", new Object[0]);
        }
        return value;
    }

    private Supplier<String> loadTextExpression(FormatSpecGrammarParser.TextExpressionContext ctx) {
        Supplier<String> textExpression;
        FormatSpecGrammarParser.SimpleTextContext simpleTextCtx = ctx.simpleText();
        if (simpleTextCtx != null) {
            textExpression = FinalSupplier.of(this.decodeQuotedString(simpleTextCtx.getText()));
        } else {
            FormatSpecGrammarParser.FormatTextContext formatTextCtx = ctx.formatText();
            if (formatTextCtx != null) {
                String formatText = this.decodeQuotedString(formatTextCtx.getText());
                ArrayList<Supplier<Object>> argumentSpecs = new ArrayList<Supplier<Object>>();
                for (FormatSpecGrammarParser.FormatTextArgumentContext formatTextArgumentCtx : ctx.formatTextArgument()) {
                    FormatSpecGrammarParser.SpecReferenceContext specReferenceCtx = formatTextArgumentCtx.specReference();
                    if (specReferenceCtx != null) {
                        argumentSpecs.add(this.resolveSpec(specReferenceCtx.referencedSpec().specIdentifier(), AttributeSpec.class));
                        continue;
                    }
                    FormatSpecGrammarParser.ExternalReferenceContext externalReferenceCtx = formatTextArgumentCtx.externalReference();
                    if (externalReferenceCtx != null) {
                        argumentSpecs.add(this.resolveExternalReference(externalReferenceCtx, Object.class));
                        continue;
                    }
                    throw this.newLoadException(formatTextArgumentCtx, "Unexpected format text argument expression", new Object[0]);
                }
                textExpression = () -> String.format(formatText, argumentSpecs.stream().map(Supplier::get).map(o -> o instanceof String ? Strings.encode((CharSequence)StringHelper.strip((String)o)) : o).toArray());
            } else {
                throw this.newLoadException(ctx, "Unexpected text expression", new Object[0]);
            }
        }
        return textExpression;
    }

    private String decodeReqexString(String regexString) {
        return Strings.decode((CharSequence)regexString.substring(2, regexString.length() - 1));
    }

    private String decodeQuotedString(String quotedString) {
        return Strings.decode((CharSequence)quotedString.substring(1, quotedString.length() - 1));
    }

    private Class<?> resolveExternalReferenceType(FormatSpecGrammarParser.ExternalReferenceContext externalReferenceCtx) {
        Method method;
        String methodIdentifier = externalReferenceCtx.referencedExternal().getText();
        try {
            method = this.getClass().getMethod(methodIdentifier, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw this.newLoadException(e, externalReferenceCtx, UNKNOWN_EXTERNAL_REFERENCE, methodIdentifier);
        }
        return method.getReturnType();
    }

    private <T> Supplier<T> resolveExternalReference(FormatSpecGrammarParser.ExternalReferenceContext externalReferenceCtx, Class<T> type) {
        Method method;
        String methodIdentifier = externalReferenceCtx.referencedExternal().getText();
        try {
            method = this.getClass().getMethod(methodIdentifier, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw this.newLoadException(e, externalReferenceCtx, UNKNOWN_EXTERNAL_REFERENCE, methodIdentifier);
        }
        Class<?> methodType = method.getReturnType();
        if (!type.isAssignableFrom(methodType)) {
            throw this.newLoadException(externalReferenceCtx, INVALID_EXTERNAL_REFERENCE, methodIdentifier, type.getSimpleName(), methodType.getSimpleName());
        }
        method.setAccessible(true);
        return () -> {
            try {
                return type.cast(method.invoke((Object)this, new Object[0]));
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw Exceptions.toRuntime((Throwable)(cause != null ? cause : e));
            }
            catch (ReflectiveOperationException e) {
                throw Exceptions.toRuntime((Throwable)e);
            }
        };
    }

    private String reserveSpecIdentifier(FormatSpecGrammarParser.SpecIdentifierContext specIdentifierCtx) {
        String specIdentifier = specIdentifierCtx.getText();
        if (this.specs.containsKey(specIdentifier)) {
            throw this.newLoadException(specIdentifierCtx, "Duplicate spec identifier @%s", specIdentifier);
        }
        this.specs.put(specIdentifier, () -> {
            throw this.newLoadException(specIdentifierCtx, "Cyclic spec reference @%s", specIdentifier);
        });
        return specIdentifier;
    }

    private <T extends FormatSpec> T resolveSpec(FormatSpecGrammarParser.FormatSpecsContext rootCtx, FormatSpecGrammarParser.SpecIdentifierContext specIdentifierCtx, Class<T> specType) {
        String specIdentifier = specIdentifierCtx.getText();
        Supplier<FormatSpec> resolvedSpecSupplier = this.specs.get(specIdentifier);
        FormatSpec resolvedSpec = null;
        if (resolvedSpecSupplier == null) {
            for (FormatSpecGrammarParser.StructSpecContext structSpecCtx : rootCtx.structSpec()) {
                if (!specIdentifier.equals(structSpecCtx.specIdentifier().getText())) continue;
                resolvedSpec = this.loadStructSpec(structSpecCtx, rootCtx);
            }
            for (FormatSpecGrammarParser.ArraySpecContext arraySpecCtx : rootCtx.arraySpec()) {
                if (!specIdentifier.equals(arraySpecCtx.specIdentifier().getText())) continue;
                resolvedSpec = this.loadArraySpec(arraySpecCtx, rootCtx);
            }
            for (FormatSpecGrammarParser.UnionSpecContext unionSpecCtx : rootCtx.unionSpec()) {
                if (!specIdentifier.equals(unionSpecCtx.specIdentifier().getText())) continue;
                resolvedSpec = this.loadUnionSpec(unionSpecCtx, rootCtx);
            }
            for (FormatSpecGrammarParser.SequenceSpecContext sequenceSpecCtx : rootCtx.sequenceSpec()) {
                if (!specIdentifier.equals(sequenceSpecCtx.specIdentifier().getText())) continue;
                resolvedSpec = this.loadSequenceSpec(sequenceSpecCtx, rootCtx);
            }
        } else {
            resolvedSpec = resolvedSpecSupplier.get();
        }
        if (resolvedSpec == null) {
            throw this.newLoadException(specIdentifierCtx, UNKNOWN_SPEC_REFERENCE, specIdentifier);
        }
        Class<?> resolvedSpecType = resolvedSpec.getClass();
        if (!specType.isAssignableFrom(resolvedSpecType)) {
            throw this.newLoadException(specIdentifierCtx, INVALID_SPEC_REFERENCE, specIdentifier, specType.getSimpleName(), resolvedSpecType.getSimpleName());
        }
        return (T)((FormatSpec)specType.cast(resolvedSpec));
    }

    private <T extends FormatSpec> T resolveSpec(FormatSpecGrammarParser.SpecIdentifierContext specIdentifierCtx, Class<T> specType) {
        String specIdentifier = specIdentifierCtx.getText();
        Supplier<FormatSpec> resolvedSpecSupplier = this.specs.get(specIdentifier);
        if (resolvedSpecSupplier == null) {
            throw this.newLoadException(specIdentifierCtx, UNKNOWN_SPEC_REFERENCE, specIdentifier);
        }
        FormatSpec resolvedSpec = resolvedSpecSupplier.get();
        Class<?> resolvedSpecType = resolvedSpec.getClass();
        if (!specType.isAssignableFrom(resolvedSpecType)) {
            throw this.newLoadException(specIdentifierCtx, INVALID_SPEC_REFERENCE, specIdentifier, specType.getSimpleName(), resolvedSpecType.getSimpleName());
        }
        return (T)((FormatSpec)specType.cast(resolvedSpec));
    }

    protected <T extends FormatSpec> T resolveSpec(String specIdentifier, Class<T> specType) {
        Supplier<FormatSpec> resolvedSpecSupplier = this.specs.get(specIdentifier);
        if (resolvedSpecSupplier == null) {
            throw new IllegalArgumentException(String.format(UNKNOWN_SPEC_REFERENCE, specIdentifier));
        }
        FormatSpec resolvedSpec = resolvedSpecSupplier.get();
        Class<?> resolvedSpecType = resolvedSpec.getClass();
        if (!specType.isAssignableFrom(resolvedSpecType)) {
            throw new IllegalArgumentException(String.format(INVALID_SPEC_REFERENCE, specIdentifier, specType.getSimpleName(), resolvedSpecType.getSimpleName()));
        }
        return (T)((FormatSpec)specType.cast(resolvedSpec));
    }

    protected <T extends FormatSpec> Lazy<T> resolveLazy(String specIdentifier, Class<T> specType) {
        return new Lazy(() -> this.resolveSpec(specIdentifier, specType));
    }

    private IllegalArgumentException newLoadException(ParserRuleContext ctx, String format, Object ... args) {
        return this.newLoadException(null, ctx, format, args);
    }

    private IllegalArgumentException newLoadException(@Nullable Throwable cause, ParserRuleContext ctx, String format, Object ... args) {
        StringBuilder message = new StringBuilder();
        Token startToken = ctx.getStart();
        message.append(this.getFormatSpecResource()).append("[").append(startToken.getLine()).append(":").append(startToken.getCharPositionInLine()).append("] ");
        message.append(String.format(format, args));
        return new IllegalArgumentException(message.toString(), cause);
    }

    private static class Loader
    extends FormatSpecGrammarBaseVisitor<FormatSpecDefinition> {
        private final Function<FormatSpecGrammarParser.FormatSpecsContext, FormatSpecDefinition> loadHelper;

        Loader(Function<FormatSpecGrammarParser.FormatSpecsContext, FormatSpecDefinition> loadHelper) {
            this.loadHelper = loadHelper;
        }

        @Override
        public FormatSpecDefinition visitFormatSpecs(@Nullable FormatSpecGrammarParser.FormatSpecsContext ctx) {
            return this.loadHelper.apply(Objects.requireNonNull(ctx));
        }
    }

    private static class ErrorListener
    extends BaseErrorListener {
        private final URL formatSpecResourceUrl;

        ErrorListener(URL formatSpecResourceUrl) {
            this.formatSpecResourceUrl = formatSpecResourceUrl;
        }

        public void syntaxError(@Nullable Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @Nullable String msg, @Nullable RecognitionException e) {
            throw new ParseCancellationException(this.formatSpecResourceUrl + "[" + line + ":" + charPositionInLine + "] '" + msg, (Throwable)e);
        }
    }
}

