/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.input.DecodedInputMapper;
import de.carne.filescanner.engine.input.InputDecoder;
import de.carne.filescanner.engine.input.InputDecoderTable;
import de.carne.filescanner.engine.input.InputDecoders;
import de.carne.filescanner.engine.util.FinalSupplier;
import java.util.function.Supplier;

public final class EncodedInputSpecConfig {
    private static final InputDecoder UNDEFINED_INPUT_DECODER_TABLE = InputDecoders.unsupportedInputDecoder("<undefined>");
    private static final DecodedInputMapper DEFAULT_INPUT_MAPPER = new DecodedInputMapper("decoded.bin");
    private Supplier<String> encodedInputNameHolder;
    private Supplier<InputDecoderTable> inputDecoderTableHolder = FinalSupplier.of(InputDecoderTable.build(UNDEFINED_INPUT_DECODER_TABLE));
    private Supplier<DecodedInputMapper> decodedInputMapperHolder = FinalSupplier.of(DEFAULT_INPUT_MAPPER);

    public EncodedInputSpecConfig(String encodedInputName) {
        this(FinalSupplier.of(encodedInputName));
    }

    public EncodedInputSpecConfig(Supplier<String> encodedInputName) {
        this.encodedInputNameHolder = encodedInputName;
    }

    public Supplier<String> encodedInputName() {
        return this.encodedInputNameHolder;
    }

    public EncodedInputSpecConfig inputDecoderTable(InputDecoderTable inputDecoderTable) {
        return this.inputDecoderTable(FinalSupplier.of(inputDecoderTable));
    }

    public EncodedInputSpecConfig inputDecoderTable(Supplier<InputDecoderTable> inputDecoderTable) {
        this.inputDecoderTableHolder = inputDecoderTable;
        return this;
    }

    public Supplier<InputDecoderTable> inputDecoderTable() {
        return this.inputDecoderTableHolder;
    }

    public EncodedInputSpecConfig decodedInputName(String decodedInputName) {
        return this.decodedInputName(FinalSupplier.of(decodedInputName));
    }

    public EncodedInputSpecConfig decodedInputName(Supplier<String> decodedInputName) {
        return this.decodedInputMapper(new DecodedInputMapper(decodedInputName));
    }

    public EncodedInputSpecConfig decodedInputMapper(DecodedInputMapper decodedInputMapper) {
        return this.decodedInputMapper(FinalSupplier.of(decodedInputMapper));
    }

    public EncodedInputSpecConfig decodedInputMapper(Supplier<DecodedInputMapper> decodedInputMapper) {
        this.decodedInputMapperHolder = decodedInputMapper;
        return this;
    }

    public Supplier<DecodedInputMapper> decodedInputMapper() {
        return this.decodedInputMapperHolder;
    }
}

