/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultContextValueSpecs;
import de.carne.filescanner.engine.FileScannerResultDecodeContext;
import de.carne.filescanner.engine.FileScannerResultRenderContext;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.FormatSpec;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.util.FinalSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

public class DecodeAtSpec
implements FormatSpec {
    private Supplier<? extends Number> position = FinalSupplier.of(0);
    private int level = 0;
    private final CompositeSpec spec;

    public DecodeAtSpec(CompositeSpec spec) {
        if (!spec.isResult()) {
            throw new IllegalArgumentException("Relocated spec is not a result spec: " + spec);
        }
        this.spec = spec;
    }

    public DecodeAtSpec position(Supplier<? extends Number> positionSupplier) {
        this.position = positionSupplier;
        return this;
    }

    public DecodeAtSpec position(long positionValue) {
        return this.position(FinalSupplier.of(positionValue));
    }

    public DecodeAtSpec level(int levelValue) {
        if (levelValue < 0) {
            throw new IllegalArgumentException("Invalid level value: " + levelValue);
        }
        this.level = levelValue;
        return this;
    }

    @Override
    public boolean isFixedSize() {
        return this.spec.isFixedSize();
    }

    @Override
    public int matchSize() {
        return this.spec.matchSize();
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        return this.spec.matches(buffer);
    }

    @Override
    public void decode(FileScannerResultDecodeContext context) throws IOException {
        long decodeBase = (Long)FileScannerResultContextValueSpecs.FORMAT_POSITION.get();
        long decodePosition = decodeBase + this.position.get().longValue();
        context.decodeComposite(this.spec, decodePosition, this.level);
    }

    @Override
    public void render(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        this.spec.render(out, context);
    }

    public String toString() {
        return this.position + ": " + this.spec;
    }
}

