/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.filescanner.engine.util.HexFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;

public class DWordArraySpec
extends AttributeSpec<int[]> {
    private Supplier<? extends Number> size = FinalSupplier.of(0);

    public DWordArraySpec(Supplier<String> name) {
        super(int[].class, Arrays::equals, name);
        this.format(HexFormat.INT_ARRAY_FORMATTER);
    }

    public DWordArraySpec(String name) {
        this(FinalSupplier.of(name));
    }

    public DWordArraySpec length(Supplier<? extends Number> lengthSupplier) {
        this.size = lengthSupplier instanceof FinalSupplier ? FinalSupplier.of(lengthSupplier.get().intValue() << 2) : () -> ((Number)lengthSupplier.get()).intValue() << 2;
        return this;
    }

    public DWordArraySpec length(int lengthValue) {
        this.size = FinalSupplier.of(lengthValue);
        return this;
    }

    @Override
    public boolean isFixedSize() {
        return FormatSpecs.isFixedSize(this.size);
    }

    @Override
    public int matchSize() {
        return FormatSpecs.matchSize(this.size);
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        return FormatSpecs.matches(buffer, this.size, b -> this.validateValue(this.decodeValue((ByteBuffer)b)));
    }

    @Override
    protected int[] decodeValue(FileScannerResultInputContext context) throws IOException {
        return context.readValue(this.size.get().intValue(), this::decodeValue);
    }

    private int[] decodeValue(ByteBuffer buffer) {
        ByteBuffer slice = buffer.slice();
        slice.limit(this.size.get().intValue());
        int[] value = new int[slice.remaining() >> 2];
        int valueIndex = 0;
        while (slice.hasRemaining()) {
            value[valueIndex] = slice.getInt();
            ++valueIndex;
        }
        buffer.position(buffer.position() + slice.position());
        return value;
    }
}

