/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultDecodeContext;
import de.carne.filescanner.engine.FileScannerResultRenderContext;
import de.carne.filescanner.engine.format.FormatSpec;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.util.Check;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;

public abstract class CompositeSpec
implements FormatSpec {
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private boolean result = false;
    private Supplier<String> resultName = FinalSupplier.of("<undefined>");
    private @Nullable Supplier<FileScannerResultRenderHandler> customRenderHandler = null;
    private List<Supplier<FileScannerResultExportHandler>> exportHandlers = new ArrayList<Supplier<FileScannerResultExportHandler>>();

    public CompositeSpec byteOrder(ByteOrder order) {
        this.byteOrder = order;
        return this;
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public CompositeSpec result(Supplier<String> name) {
        this.result = true;
        this.resultName = name;
        return this;
    }

    public CompositeSpec result(String name) {
        return this.result(FinalSupplier.of(name));
    }

    public CompositeSpec renderer(FileScannerResultRenderHandler renderHandler) {
        this.customRenderHandler = FinalSupplier.of(renderHandler);
        return this;
    }

    public CompositeSpec renderer(Supplier<FileScannerResultRenderHandler> renderHandler) {
        this.customRenderHandler = renderHandler;
        return this;
    }

    public CompositeSpec export(Supplier<FileScannerResultExportHandler> exportHandler) {
        this.exportHandlers.add(exportHandler);
        return this;
    }

    public CompositeSpec export(FileScannerResultExportHandler exportHandler) {
        this.exportHandlers.add(FinalSupplier.of(exportHandler));
        return this;
    }

    protected void mergeDecodedExports(CompositeSpec spec) {
        this.exportHandlers.addAll(spec.exportHandlers);
    }

    public boolean isResult() {
        return this.result;
    }

    public Supplier<String> resultName() {
        Check.assertTrue((boolean)this.result);
        return this.resultName;
    }

    protected boolean hasRenderer() {
        return this.customRenderHandler != null;
    }

    protected boolean hasExportHandlers() {
        return !this.exportHandlers.isEmpty();
    }

    @Override
    public final void decode(FileScannerResultDecodeContext context) throws IOException {
        context.decodeComposite(this);
    }

    public abstract void decodeComposite(FileScannerResultDecodeContext var1) throws IOException;

    @Override
    public final void render(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        context.render(out, this);
    }

    public void renderComposite(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        if (this.customRenderHandler != null) {
            this.customRenderHandler.get().render(out, context);
        }
    }

    public List<Supplier<FileScannerResultExportHandler>> exportHandlers() {
        return Collections.unmodifiableList(this.exportHandlers);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(').append(this.getClass().getTypeName()).append(')');
        if (this.result) {
            buffer.append('\'').append(this.resultName).append('\'');
        } else {
            buffer.append("<anonoymous>");
        }
        return buffer.toString();
    }
}

