/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.format.StringAttributeSpec;
import de.carne.filescanner.engine.util.FinalSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

public class CharArraySpec
extends StringAttributeSpec {
    private Supplier<? extends Number> size = FinalSupplier.of(0);

    public CharArraySpec(Supplier<String> name) {
        super(name);
    }

    public CharArraySpec(String name) {
        super(FinalSupplier.of(name));
    }

    public CharArraySpec size(Supplier<? extends Number> sizeSupplier) {
        this.size = sizeSupplier;
        return this;
    }

    public CharArraySpec size(int sizeValue) {
        this.size = FinalSupplier.of(sizeValue);
        return this;
    }

    @Override
    public boolean isFixedSize() {
        return FormatSpecs.isFixedSize(this.size);
    }

    @Override
    public int matchSize() {
        return this.isFixedSize() ? this.size.get().intValue() : 0;
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        return !this.isFixedSize() || this.size.get().intValue() <= buffer.remaining() && this.validateValue(this.decodeValue(buffer));
    }

    @Override
    protected String decodeValue(FileScannerResultInputContext context) throws IOException {
        return context.readValue(this.size.get().intValue(), this::decodeValue);
    }

    private String decodeValue(ByteBuffer buffer) {
        ByteBuffer slice = buffer.slice();
        slice.limit(this.size.get().intValue());
        String value = this.charset().decode(slice).toString();
        buffer.position(buffer.position() + slice.position());
        return value;
    }
}

