/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.format.FlagRenderer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.Nullable;

public class ByteFlagRenderer
extends FlagRenderer<Byte> {
    private static final long serialVersionUID = -8064762212173430381L;
    private static final byte MSB = -128;

    @Override
    public @Nullable String put(byte flag, String symbol) {
        return this.put(Byte.valueOf(flag), symbol);
    }

    @Override
    protected Iterator<Byte> flags() {
        return new Iterator<Byte>(){
            private byte nextFlag = (byte)-128;

            @Override
            public boolean hasNext() {
                return this.nextFlag != 0;
            }

            @Override
            public Byte next() {
                if (this.nextFlag == 0) {
                    throw new NoSuchElementException();
                }
                byte flag = this.nextFlag;
                this.nextFlag = ByteFlagRenderer.shift(this.nextFlag);
                return flag;
            }
        };
    }

    @Override
    protected boolean testFlag(Byte value, Byte flag) {
        byte flagValue = flag;
        return (value & flagValue) != 0;
    }

    @Override
    protected Byte combineFlags(Byte flag1, Byte flag2) {
        return (byte)((flag1 | flag2) & 0xFF);
    }

    @Override
    protected String formatFlag(Byte value, Byte flag) {
        StringBuilder buffer = new StringBuilder();
        byte valueValue = value;
        byte flagValue = flag;
        byte mask = -128;
        while (mask != 0) {
            if ((flagValue & mask) != mask) {
                buffer.append('.');
            } else if ((flagValue & valueValue) != 0) {
                buffer.append('1');
            } else {
                buffer.append('0');
            }
            mask = ByteFlagRenderer.shift(mask);
        }
        return buffer.toString();
    }

    static byte shift(byte flag) {
        return (byte)((flag & 0xFF) >>> 1);
    }
}

