/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.filescanner.engine.util.HexFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;

public class ByteArraySpec
extends AttributeSpec<byte[]> {
    private Supplier<? extends Number> size = FinalSupplier.of(0);

    public ByteArraySpec(Supplier<String> name) {
        super(byte[].class, Arrays::equals, name);
        this.format(HexFormat.BYTE_ARRAY_FORMATTER);
    }

    public ByteArraySpec(String name) {
        this(FinalSupplier.of(name));
    }

    public ByteArraySpec length(Supplier<? extends Number> lengthSupplier) {
        this.size = lengthSupplier;
        return this;
    }

    public ByteArraySpec length(int lengthValue) {
        this.size = FinalSupplier.of(lengthValue);
        return this;
    }

    @Override
    public boolean isFixedSize() {
        return FormatSpecs.isFixedSize(this.size);
    }

    @Override
    public int matchSize() {
        return FormatSpecs.matchSize(this.size);
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        return FormatSpecs.matches(buffer, this.size, b -> this.validateValue(this.decodeValue((ByteBuffer)b)));
    }

    @Override
    protected byte[] decodeValue(FileScannerResultInputContext context) throws IOException {
        return context.readValue(this.size.get().intValue(), this::decodeValue);
    }

    private byte[] decodeValue(ByteBuffer buffer) {
        ByteBuffer slice = buffer.slice();
        slice.limit(this.size.get().intValue());
        byte[] value = new byte[slice.remaining()];
        int valueIndex = 0;
        while (slice.hasRemaining()) {
            value[valueIndex] = slice.get();
            ++valueIndex;
        }
        buffer.position(buffer.position() + slice.position());
        return value;
    }
}

