/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine;

import de.carne.filescanner.engine.FormatDecodeException;
import de.carne.filescanner.engine.util.HexFormat;
import de.carne.util.Strings;
import java.lang.reflect.Array;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public class UnexpectedDataException
extends FormatDecodeException {
    private static final long serialVersionUID = -5971215303926847087L;

    public UnexpectedDataException(String hint) {
        this(hint, -1L);
    }

    public UnexpectedDataException(String hint, long position) {
        super(UnexpectedDataException.formatData(hint, position, null));
    }

    public UnexpectedDataException(String hint, long position, Object data) {
        super(UnexpectedDataException.formatData(hint, position, data));
    }

    private static String formatData(String hint, long position, @Nullable Object data) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(hint);
        if (position >= 0L) {
            buffer.append(" [");
            HexFormat.formatLong(buffer, position);
            buffer.append("]: ");
        } else {
            buffer.append(": ");
        }
        if (data != null) {
            UnexpectedDataException.formatData(buffer, data);
        } else {
            buffer.append("{ ... }");
        }
        return buffer.toString();
    }

    private static StringBuilder formatData(StringBuilder buffer, @Nullable Object data) {
        if (data == null) {
            buffer.append("null");
        } else {
            Class<?> dataType = data.getClass();
            if (dataType.isArray()) {
                buffer.append("{ ");
                int length = Array.getLength(data);
                for (int index = 0; index < length; ++index) {
                    if (index > 0) {
                        buffer.append(", ");
                    }
                    UnexpectedDataException.formatData(buffer, Array.get(data, index));
                }
                buffer.append(" }");
            } else if (dataType.equals(Long.class)) {
                buffer.append(HexFormat.formatLong((Long)data));
            } else if (dataType.equals(Integer.class)) {
                buffer.append(HexFormat.formatInt((Integer)data));
            } else if (dataType.equals(Short.class)) {
                buffer.append(HexFormat.formatShort((Short)data));
            } else if (dataType.equals(Byte.class)) {
                buffer.append(HexFormat.formatByte((Byte)data));
            } else {
                buffer.append(Strings.encode((CharSequence)Objects.toString(data)));
            }
        }
        return buffer;
    }
}

