/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine;

import de.carne.filescanner.engine.spi.Format;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public final class Formats
implements Iterable<Format> {
    private final Set<Format> allFormats = new HashSet<Format>();
    private final Set<String> disabledFormats = new HashSet<String>();

    private Formats() {
        Format.providers().forEach(this.allFormats::add);
    }

    public static Formats all() {
        return new Formats();
    }

    public Formats enable(Format format) {
        return this.enable(format.name());
    }

    public Formats enable(String name) {
        this.disabledFormats.remove(name);
        return this;
    }

    public Formats disable(Format format) {
        return this.disable(format.name());
    }

    public Formats disable(String name) {
        this.disabledFormats.add(name);
        return this;
    }

    public Set<Format> enabledFormats() {
        return this.allFormats.stream().filter(format -> !this.disabledFormats.contains(format.name())).collect(Collectors.toSet());
    }

    @Override
    public Iterator<Format> iterator() {
        return Collections.unmodifiableSet(this.allFormats).iterator();
    }
}

