/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine;

import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.input.FileScannerInputRange;
import de.carne.filescanner.engine.spi.Format;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

final class FormatMatcherBuilder {
    private final Format[] formats;
    private final int matchHeaderBufferSize;
    private final int matchTrailerBufferSize;

    FormatMatcherBuilder(Collection<Format> formats) {
        this.formats = formats.toArray(new Format[formats.size()]);
        this.matchHeaderBufferSize = this.matchHeaderBufferSize();
        this.matchTrailerBufferSize = this.matchTrailerBufferSize();
    }

    private int matchHeaderBufferSize() {
        int matchBufferSize = 0;
        for (Format format : this.formats) {
            for (CompositeSpec headerSpec : format.headerSpecs()) {
                matchBufferSize = Math.max(matchBufferSize, headerSpec.matchSize());
            }
        }
        return matchBufferSize;
    }

    private int matchTrailerBufferSize() {
        int matchBufferSize = 0;
        for (Format format : this.formats) {
            for (CompositeSpec trailerSpec : format.trailerSpecs()) {
                matchBufferSize = Math.max(matchBufferSize, trailerSpec.matchSize());
            }
        }
        return matchBufferSize;
    }

    public Matcher matcher() {
        return new Matcher(this.formats, this.matchHeaderBufferSize, this.matchTrailerBufferSize);
    }

    public final class Matcher {
        private final Format[] matcherFormats;
        private final ByteBuffer matchHeaderBuffer;
        private final ByteBuffer matchTrailerBuffer;

        public Matcher(Format[] matcherFormats, int matchHeaderBufferSize, int matchTrailerBufferSize) {
            this.matcherFormats = matcherFormats;
            this.matchHeaderBuffer = ByteBuffer.allocate(matchHeaderBufferSize);
            this.matchTrailerBuffer = ByteBuffer.allocate(matchTrailerBufferSize);
        }

        public List<Format> match(FileScannerInputRange inputRange, long scanPosition) throws IOException {
            this.matchHeaderBuffer.rewind();
            inputRange.read(this.matchHeaderBuffer, scanPosition);
            this.matchHeaderBuffer.flip();
            if (scanPosition == 0L) {
                this.matchTrailerBuffer.rewind();
                inputRange.read(this.matchTrailerBuffer, Math.max(scanPosition, inputRange.end() - (long)this.matchTrailerBuffer.capacity()));
                this.matchTrailerBuffer.flip();
            }
            ArrayList<Format> matchingFormats = new ArrayList<Format>(this.matcherFormats.length);
            int trailerMatches = 0;
            int headerMatches = 0;
            int inputNameMatches = 0;
            for (Format format : this.matcherFormats) {
                if (scanPosition != 0L && format.isAbsolute()) continue;
                if (format.hasHeaderSpecs()) {
                    if (!this.matchHeaderSpecs(format, this.matchHeaderBuffer)) continue;
                    matchingFormats.add(trailerMatches + headerMatches, format);
                    ++headerMatches;
                    continue;
                }
                if (format.hasTrailerSpecs()) {
                    if (!this.matchTrailerSpecs(format, this.matchTrailerBuffer)) continue;
                    matchingFormats.add(trailerMatches, format);
                    ++trailerMatches;
                    continue;
                }
                if (format.hasInputNamePatterns()) {
                    if (!this.matchInputNamePatterns(format, inputRange.name())) continue;
                    matchingFormats.add(trailerMatches + headerMatches + inputNameMatches, format);
                    ++inputNameMatches;
                    continue;
                }
                matchingFormats.add(format);
            }
            return matchingFormats;
        }

        private boolean matchHeaderSpecs(Format format, ByteBuffer matchBuffer) {
            boolean match = false;
            for (CompositeSpec headerSpec : format.headerSpecs()) {
                matchBuffer.rewind();
                matchBuffer.order(headerSpec.byteOrder());
                if (!headerSpec.matches(matchBuffer)) continue;
                match = true;
                break;
            }
            return match;
        }

        private boolean matchTrailerSpecs(Format format, ByteBuffer matchBuffer) {
            boolean match = false;
            for (CompositeSpec trailerSpec : format.trailerSpecs()) {
                matchBuffer.rewind();
                matchBuffer.order(trailerSpec.byteOrder());
                int matchPosition = matchBuffer.remaining() - trailerSpec.matchSize();
                if (matchPosition < 0) continue;
                matchBuffer.position(matchPosition);
                if (!trailerSpec.matches(matchBuffer)) continue;
                match = true;
                break;
            }
            return match;
        }

        private boolean matchInputNamePatterns(Format format, String inputName) {
            boolean match = false;
            for (Pattern inputNamePattern : format.inputNamePatterns()) {
                if (!inputNamePattern.matcher(inputName).matches()) continue;
                match = true;
                break;
            }
            return match;
        }
    }
}

