/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine;

import de.carne.filescanner.engine.FileScannerResult;
import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.filescanner.engine.util.FileNames;
import de.carne.filescanner.engine.util.HexFormat;
import de.carne.filescanner.engine.util.PrettyFormat;
import de.carne.text.MemoryUnitFormat;
import java.io.IOException;
import org.eclipse.jdt.annotation.Nullable;

public final class FileScannerResults {
    private FileScannerResults() {
    }

    public static void renderDefault(FileScannerResult result, RenderOutput out) throws IOException {
        if (result.type() == FileScannerResult.Type.INPUT) {
            FileScannerInput input = result.input();
            out.setStyle(RenderStyle.NORMAL).write("file");
            out.setStyle(RenderStyle.OPERATOR).write(" = ");
            out.setStyle(RenderStyle.VALUE).writeln(PrettyFormat.formatString(input.name()));
            out.setStyle(RenderStyle.NORMAL).write("size");
            out.setStyle(RenderStyle.OPERATOR).write(" = ");
            out.setStyle(RenderStyle.VALUE).write(PrettyFormat.formatLongNumber(input.size()));
            out.setStyle(RenderStyle.COMMENT).write(" // ").writeln(MemoryUnitFormat.getMemoryUnitInstance().format((double)input.size() * 1.0));
        } else {
            out.setStyle(RenderStyle.NORMAL).write("start");
            out.setStyle(RenderStyle.OPERATOR).write(" = ");
            out.setStyle(RenderStyle.VALUE).writeln(HexFormat.formatLong(result.start()));
            out.setStyle(RenderStyle.NORMAL).write("end");
            out.setStyle(RenderStyle.OPERATOR).write(" = ");
            out.setStyle(RenderStyle.VALUE).writeln(HexFormat.formatLong(result.end()));
            out.setStyle(RenderStyle.NORMAL).write("size");
            out.setStyle(RenderStyle.OPERATOR).write(" = ");
            out.setStyle(RenderStyle.VALUE).write(PrettyFormat.formatLongNumber(result.size()));
            out.setStyle(RenderStyle.COMMENT).write(" // ").writeln(MemoryUnitFormat.getMemoryUnitInstance().format((double)result.size() * 1.0));
        }
    }

    public static String defaultFileName(FileScannerResult result, @Nullable String extension) throws IOException {
        FileScannerInput input = FileScannerResults.isInput(result);
        return FileNames.mangleFileName(input != null ? input.name() : result.name(), extension);
    }

    private static @Nullable FileScannerInput isInput(FileScannerResult result) throws IOException {
        FileScannerInput input = result.input();
        return result.type() == FileScannerResult.Type.INPUT || result.start() == 0L && result.end() == input.size() ? input : null;
    }
}

