/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine;

import de.carne.filescanner.engine.FileScannerResultContext;
import de.carne.filescanner.engine.util.FinalSupplier;
import java.util.function.Supplier;

public class FileScannerResultContextValueSpec<T>
implements Supplier<T> {
    private final Class<T> type;
    private final Supplier<String> name;

    public FileScannerResultContextValueSpec(Class<T> type, String name) {
        this(type, FinalSupplier.of(name));
    }

    public FileScannerResultContextValueSpec(Class<T> type, Supplier<String> name) {
        this.type = type;
        this.name = name;
    }

    public final Class<T> type() {
        return this.type;
    }

    public final String name() {
        return this.name.get();
    }

    @Override
    public T get() {
        return FileScannerResultContext.get().getValue(this);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        this.formatType(buffer, this.type);
        buffer.append(')');
        this.formatName(buffer, this.name);
        return buffer.toString();
    }

    protected void formatType(StringBuilder buffer, Class<?> formatType) {
        Class<?> componenentType = formatType.getComponentType();
        if (componenentType != null) {
            this.formatType(buffer, componenentType);
            buffer.append("[]");
        } else {
            buffer.append(formatType.getName());
        }
    }

    protected void formatName(StringBuilder buffer, Supplier<String> formatName) {
        buffer.append('\'').append(formatName).append('\'');
    }
}

