/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine;

import de.carne.filescanner.engine.FileScannerResultContextValueSpec;
import de.carne.filescanner.engine.FileScannerRunnableT;
import de.carne.filescanner.engine.FileScannerRunnableV;
import java.io.IOException;
import org.eclipse.jdt.annotation.Nullable;

public abstract class FileScannerResultContext {
    private static final ThreadLocal<@Nullable FileScannerResultContext> CONTEXT = new ThreadLocal();

    public static FileScannerResultContext get() {
        FileScannerResultContext context = CONTEXT.get();
        if (context == null) {
            throw new IllegalStateException("Context only available during decode or render call");
        }
        return context;
    }

    protected boolean inContext(Class<? extends FileScannerResultContext> contextType) {
        FileScannerResultContext context = CONTEXT.get();
        return context != null && contextType.isAssignableFrom(context.getClass());
    }

    protected void runV(FileScannerRunnableV runnable) throws IOException {
        FileScannerResultContext previousContext = CONTEXT.get();
        if (this.equals(previousContext)) {
            runnable.run();
        } else {
            CONTEXT.set(this);
            try {
                runnable.run();
            }
            finally {
                if (previousContext != null) {
                    CONTEXT.set(previousContext);
                } else {
                    CONTEXT.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T runT(FileScannerRunnableT<T> runnable) throws IOException {
        T result;
        FileScannerResultContext previousContext = CONTEXT.get();
        if (this.equals(previousContext)) {
            result = runnable.run();
        } else {
            CONTEXT.set(this);
            try {
                result = runnable.run();
            }
            finally {
                if (previousContext != null) {
                    CONTEXT.set(previousContext);
                } else {
                    CONTEXT.remove();
                }
            }
        }
        return result;
    }

    public abstract <T> T getValue(FileScannerResultContextValueSpec<T> var1);
}

