/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine;

public final class FileScannerProgress {
    private final long scanStartedNanos;
    private final long scanTimeNanos;
    private final long scannedBytes;
    private final long totalInputBytes;

    FileScannerProgress(long scanStartedNanos, long scanTimeNanos, long scannedBytes, long totalInputBytes) {
        this.scanStartedNanos = scanStartedNanos;
        this.scanTimeNanos = scanTimeNanos;
        this.scannedBytes = scannedBytes;
        this.totalInputBytes = totalInputBytes;
    }

    public long scanStartedNanos() {
        return this.scanStartedNanos;
    }

    public long scanTimeNanos() {
        return this.scanTimeNanos;
    }

    public long scannedBytes() {
        return this.scannedBytes;
    }

    public long totalInputBytes() {
        return this.totalInputBytes;
    }

    public int scanProgress() {
        return this.totalInputBytes > 0L ? (int)(this.scannedBytes * 100L / this.totalInputBytes) : 0;
    }

    public long scanRate() {
        return this.scanTimeNanos > 1000000000L ? this.scannedBytes / (this.scanTimeNanos / 1000000000L) : -1L;
    }
}

