/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.validation;

import de.carne.util.MessageFormatter;
import de.carne.util.validation.ValidationException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class PathValidator {
    private PathValidator() {
    }

    public static Path isPath(String input, MessageFormatter message) throws ValidationException {
        Path path;
        assert (input != null);
        assert (message != null);
        try {
            path = Paths.get(input, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new ValidationException(message.format(input), e);
        }
        return path;
    }

    public static Path isPath(Path basePath, String input, MessageFormatter message) throws ValidationException {
        Path path;
        assert (basePath != null);
        assert (input != null);
        assert (message != null);
        try {
            path = basePath.resolve(input);
        }
        catch (InvalidPathException e) {
            throw new ValidationException(message.format(input), e);
        }
        return path;
    }

    public static Path isRegularFilePath(String input, MessageFormatter message) throws ValidationException {
        Path inputPath = PathValidator.isPath(input, message);
        if (!Files.isRegularFile(inputPath, new LinkOption[0])) {
            throw new ValidationException(message.format(input));
        }
        return inputPath;
    }

    public static Path isDirectoryPath(String input, MessageFormatter message) throws ValidationException {
        Path inputPath = PathValidator.isPath(input, message);
        if (!Files.isDirectory(inputPath, new LinkOption[0])) {
            throw new ValidationException(message.format(input));
        }
        return inputPath;
    }

    public static Path isReadablePath(String input, MessageFormatter message) throws ValidationException {
        Path inputPath = PathValidator.isPath(input, message);
        if (!Files.isReadable(inputPath)) {
            throw new ValidationException(message.format(input));
        }
        return inputPath;
    }

    public static Path isWritablePath(String input, MessageFormatter message) throws ValidationException {
        Path inputPath = PathValidator.isPath(input, message);
        if (!Files.isWritable(inputPath)) {
            throw new ValidationException(message.format(input));
        }
        return inputPath;
    }
}

