/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.validation;

import de.carne.check.Nullable;
import de.carne.util.MessageFormatter;
import de.carne.util.validation.ValidationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InputValidator {
    private InputValidator() {
    }

    public static void isTrue(boolean condition, MessageFormatter message) throws ValidationException {
        assert (message != null);
        if (!condition) {
            throw new ValidationException(message.format(new Object[0]));
        }
    }

    public static <T> T notNull(@Nullable T input, MessageFormatter message) throws ValidationException {
        assert (message != null);
        if (input == null) {
            throw new ValidationException(message.format(new Object[0]));
        }
        return input;
    }

    public static String notEmpty(@Nullable String input, MessageFormatter message) throws ValidationException {
        assert (message != null);
        if (input == null || input.length() == 0) {
            throw new ValidationException(message.format(new Object[0]));
        }
        return input;
    }

    public static String[] matches(String input, Pattern pattern, MessageFormatter message) throws ValidationException {
        assert (input != null);
        assert (pattern != null);
        assert (message != null);
        Matcher matcher = pattern.matcher(input);
        if (!matcher.matches()) {
            throw new ValidationException(message.format(input));
        }
        int groupCount = matcher.groupCount();
        String[] groups = new String[groupCount];
        for (int groupIndex = 0; groupIndex < groupCount; ++groupIndex) {
            groups[groupIndex] = matcher.group(groupIndex + 1);
        }
        return groups;
    }
}

