/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.check.Nullable;
import de.carne.util.Exceptions;
import de.carne.util.logging.LogLevel;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Objects;
import java.util.logging.LogManager;

public final class LogConfig {
    private static final String THIS_PACKAGE = LogConfig.class.getPackage().getName();
    public static final String CONFIG_DEFAULT = "logging-default.properties";
    public static final String CONFIG_VERBOSE = "logging-verbose.properties";
    public static final String CONFIG_DEBUG = "logging-debug.properties";
    @Nullable
    private static String currentConfig;

    public LogConfig() {
        LogConfig.applyConfig(System.getProperty(THIS_PACKAGE, CONFIG_DEFAULT));
    }

    public static synchronized void applyConfig(@Nullable String config) {
        if (!Objects.equals(currentConfig, config)) {
            if (config != null) {
                if (!LogConfig.applyFileConfig(config)) {
                    LogConfig.applyResourceConfig(config);
                }
            } else {
                LogManager.getLogManager().reset();
            }
        }
    }

    private static boolean applyFileConfig(String config) {
        boolean applied = false;
        try (FileInputStream configStream = new FileInputStream(config);){
            LogManager.getLogManager().readConfiguration(configStream);
            applied = true;
        }
        catch (FileNotFoundException e) {
            Exceptions.ignore(e);
        }
        catch (Exception e) {
            System.err.println("An error occurred while reading logging configuration file: " + config);
            e.printStackTrace();
        }
        return applied;
    }

    private static boolean applyResourceConfig(String config) {
        boolean applied = false;
        try (InputStream configStream = Objects.requireNonNull(Thread.currentThread().getContextClassLoader()).getResourceAsStream(config);){
            if (configStream != null) {
                LogManager.getLogManager().readConfiguration(configStream);
                applied = true;
            } else {
                System.err.println("Unable to access logging configuration resource: " + config);
            }
        }
        catch (Exception e) {
            System.err.println("An error occurred while reading logging configuration resource: " + config);
            e.printStackTrace();
        }
        return applied;
    }

    static {
        LogLevel.init();
        currentConfig = null;
    }
}

