/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.check.Nullable;
import de.carne.util.PropertiesHelper;
import de.carne.util.logging.LogLineFormatter;
import de.carne.util.logging.LogMonitor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogBuffer
extends Handler {
    public static final int BUFFER_LIMIT = PropertiesHelper.getInt(LogMonitor.class, ".limit", 100);
    private final Deque<LogRecord> buffer = new ArrayDeque<LogRecord>(BUFFER_LIMIT);
    private final Set<Handler> handlers = new HashSet<Handler>();
    private final AtomicBoolean locked = new AtomicBoolean(false);

    @Nullable
    public static LogBuffer getInstance(Logger logger) {
        assert (logger != null);
        LogBuffer logBuffer = null;
        block0: for (Logger currentLogger = logger; logBuffer == null && currentLogger != null; currentLogger = currentLogger.getParent()) {
            for (Handler handler : currentLogger.getHandlers()) {
                if (!(handler instanceof LogBuffer)) continue;
                logBuffer = (LogBuffer)handler;
                continue block0;
            }
        }
        return logBuffer;
    }

    public static void addHandler(Logger logger, Handler handler) {
        LogBuffer logBuffer = LogBuffer.getInstance(logger);
        if (logBuffer != null) {
            logBuffer.addHandler(handler);
        }
    }

    public synchronized void addHandler(Handler handler) {
        assert (handler != null);
        for (LogRecord record : this.buffer) {
            handler.publish(record);
        }
        this.handlers.add(handler);
    }

    public static void removeHandler(Logger logger, Handler handler) {
        LogBuffer logBuffer = LogBuffer.getInstance(logger);
        if (logBuffer != null) {
            logBuffer.removeHandler(handler);
        }
    }

    public synchronized void removeHandler(Handler handler) {
        assert (handler != null);
        this.handlers.remove(handler);
    }

    public static void clear(Logger logger) {
        LogBuffer logBuffer = LogBuffer.getInstance(logger);
        if (logBuffer != null) {
            logBuffer.clear();
        }
    }

    public synchronized void clear() {
        this.buffer.clear();
    }

    public static void exportTo(Logger logger, File file) throws IOException {
        LogBuffer logBuffer = LogBuffer.getInstance(logger);
        if (logBuffer != null) {
            logBuffer.exportTo(file);
        }
    }

    public synchronized void exportTo(File file) throws IOException {
        assert (file != null);
        try (FileWriter writer = new FileWriter(file, false);){
            LogLineFormatter formatter = new LogLineFormatter();
            for (LogRecord record : this.buffer) {
                writer.write(formatter.format(record));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(@Nullable LogRecord record) {
        if (record != null && this.locked.compareAndSet(false, true)) {
            LogBuffer logBuffer = this;
            synchronized (logBuffer) {
                try {
                    while (this.buffer.size() >= BUFFER_LIMIT) {
                        this.buffer.removeFirst();
                    }
                    this.buffer.addLast(record);
                    this.handlers.forEach(handler -> handler.publish(record));
                }
                finally {
                    this.locked.set(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this.locked.compareAndSet(false, true)) {
            LogBuffer logBuffer = this;
            synchronized (logBuffer) {
                try {
                    this.handlers.forEach(handler -> handler.flush());
                }
                finally {
                    this.locked.set(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SecurityException {
        if (this.locked.compareAndSet(false, true)) {
            LogBuffer logBuffer = this;
            synchronized (logBuffer) {
                try {
                    this.handlers.forEach(handler -> handler.close());
                }
                finally {
                    this.locked.set(false);
                }
            }
        }
    }
}

