/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.check.Nullable;
import de.carne.util.logging.LogLevel;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Log {
    private Logger logger;

    public Log() {
        this(Log.getCallerClassName());
    }

    public Log(ResourceBundle bundle) {
        this(Log.getCallerClassName(), bundle);
    }

    public Log(Class<?> cls) {
        this(cls.getName());
    }

    public Log(Class<?> cls, @Nullable ResourceBundle bundle) {
        this(cls.getName(), bundle);
    }

    public Log(String name) {
        this(name, null);
    }

    public Log(String name, @Nullable ResourceBundle bundle) {
        this.logger = Logger.getLogger(name, bundle != null ? bundle.getBaseBundleName() : null);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean isLoggable(Level level) {
        assert (level != null);
        return this.logger.isLoggable(level);
    }

    public void log(Level level, @Nullable Throwable thrown, String msg, Object ... parameters) {
        assert (level != null);
        assert (msg != null);
        if (this.logger.isLoggable(level)) {
            LogRecord record = new LogRecord(level, msg);
            record.setResourceBundle(this.logger.getResourceBundle());
            record.setThrown(thrown);
            record.setParameters(parameters);
            record.setLoggerName(Objects.toString(this.logger.getName()));
            this.logger.log(record);
        }
    }

    public boolean isNoticeLoggable() {
        return this.isLoggable(LogLevel.LEVEL_NOTICE);
    }

    public void notice(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_NOTICE, null, msg, parameters);
    }

    public void notice(@Nullable Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_NOTICE, thrown, msg, parameters);
    }

    public boolean isErrorLoggable() {
        return this.isLoggable(LogLevel.LEVEL_ERROR);
    }

    public void error(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_ERROR, null, msg, parameters);
    }

    public void error(@Nullable Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_ERROR, thrown, msg, parameters);
    }

    public boolean isWarningLoggable() {
        return this.isLoggable(LogLevel.LEVEL_WARNING);
    }

    public void warning(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_WARNING, null, msg, parameters);
    }

    public void warning(@Nullable Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_WARNING, thrown, msg, parameters);
    }

    public boolean isInfoLoggable() {
        return this.isLoggable(LogLevel.LEVEL_INFO);
    }

    public void info(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_INFO, null, msg, parameters);
    }

    public void info(@Nullable Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_INFO, thrown, msg, parameters);
    }

    public boolean isDebugLoggable() {
        return this.isLoggable(LogLevel.LEVEL_DEBUG);
    }

    public void debug(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_DEBUG, null, msg, parameters);
    }

    public void debug(@Nullable Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_DEBUG, thrown, msg, parameters);
    }

    public boolean isTraceLoggable() {
        return this.isLoggable(LogLevel.LEVEL_TRACE);
    }

    public void trace(String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_TRACE, null, msg, parameters);
    }

    public void trace(@Nullable Throwable thrown, String msg, Object ... parameters) {
        this.log(LogLevel.LEVEL_TRACE, thrown, msg, parameters);
    }

    private static String getCallerClassName() {
        int steIndex;
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        String thisClassName = Log.class.getName();
        for (steIndex = 0; steIndex < stes.length && !thisClassName.equals(stes[steIndex].getClassName()); ++steIndex) {
        }
        while (steIndex < stes.length && thisClassName.equals(stes[steIndex].getClassName())) {
            ++steIndex;
        }
        return steIndex < stes.length ? stes[steIndex].getClassName() : thisClassName;
    }
}

