/*
 * Decompiled with CFR 0.152.
 */
package de.carne.nio;

import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;

public final class FileAttributes {
    private static final String POSIX = "posix";

    private FileAttributes() {
    }

    public static FileAttribute<?>[] defaultUserDirectoryAttributes(Path directoryPath) {
        ArrayList<FileAttribute<Set<PosixFilePermission>>> attributes = new ArrayList<FileAttribute<Set<PosixFilePermission>>>();
        Set<String> supported = directoryPath.getFileSystem().supportedFileAttributeViews();
        if (supported.contains(POSIX)) {
            attributes.add(PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE)));
        }
        return attributes.toArray(new FileAttribute[attributes.size()]);
    }

    public static FileAttribute<?>[] defaultUserFileAttributes(Path filePath) {
        ArrayList<FileAttribute<Set<PosixFilePermission>>> attributes = new ArrayList<FileAttribute<Set<PosixFilePermission>>>();
        Set<String> supported = filePath.getFileSystem().supportedFileAttributeViews();
        if (supported.contains(POSIX)) {
            attributes.add(PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE)));
        }
        return attributes.toArray(new FileAttribute[attributes.size()]);
    }
}

